/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractModuleDetector;
import edu.hm.hafner.analysis.ModuleDetector;
import edu.hm.hafner.analysis.SecureDigester;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class MavenModuleDetector
extends AbstractModuleDetector {
    static final String MAVEN_POM = "pom.xml";

    MavenModuleDetector(ModuleDetector.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    String getPattern() {
        return "**/pom.xml";
    }

    @Override
    public void collectProjects(Map<String, String> mapping, List<String> projects) {
        for (String fileName : projects) {
            if (!fileName.endsWith(MAVEN_POM)) continue;
            this.addMapping(mapping, fileName, MAVEN_POM, this.parsePom(fileName));
        }
    }

    private String parsePom(String pom) {
        String name = this.parsePomAttribute(pom, "name");
        return (String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)this.parsePomAttribute(pom, "artifactId"));
    }

    private String parsePomAttribute(String pom, String tagName) {
        String string;
        block8: {
            InputStream file = this.getFactory().open(pom);
            try {
                SecureDigester digester = new SecureDigester(ModuleDetector.class);
                digester.push(new StringBuilder());
                digester.addCallMethod("project/" + tagName, "append", 0);
                StringBuilder result = (StringBuilder)digester.parse(file);
                string = result.toString();
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException | SAXException exception) {
                    return "";
                }
            }
            file.close();
        }
        return string;
    }
}

