/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.AbstractModuleDetector;
import edu.hm.hafner.analysis.AntModuleDetector;
import edu.hm.hafner.analysis.GradleModuleDetector;
import edu.hm.hafner.analysis.MavenModuleDetector;
import edu.hm.hafner.analysis.OsgiModuleDetector;
import edu.hm.hafner.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleDetector {
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";
    private final List<AbstractModuleDetector> moduleDetectors;
    private final FileSystem factory;
    private final Map<String, String> fileNameToModuleName;
    private final List<String> prefixes;

    public ModuleDetector(Path workspace, FileSystem fileSystem) {
        this.factory = fileSystem;
        this.moduleDetectors = new ArrayList<AbstractModuleDetector>(Arrays.asList(new AntModuleDetector(this.factory), new GradleModuleDetector(this.factory), new MavenModuleDetector(this.factory), new OsgiModuleDetector(this.factory)));
        this.fileNameToModuleName = this.createFilesToModuleMapping(workspace);
        this.prefixes = new ArrayList<String>(this.fileNameToModuleName.keySet());
        Collections.sort(this.prefixes);
    }

    private Map<String, String> createFilesToModuleMapping(Path workspace) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        List<String> projects = this.find(workspace);
        for (AbstractModuleDetector moduleDetector : this.moduleDetectors) {
            moduleDetector.collectProjects(mapping, projects);
        }
        return mapping;
    }

    public String guessModuleName(String originalFileName) {
        String fullPath = originalFileName.replace('\\', '/');
        String guessedModule = "";
        for (String path : this.prefixes) {
            if (!fullPath.startsWith(path) || !this.fileNameToModuleName.containsKey(path)) continue;
            guessedModule = this.fileNameToModuleName.get(path);
        }
        return guessedModule;
    }

    private List<String> find(Path path) {
        ArrayList<String> absoluteFileNames = new ArrayList<String>();
        for (AbstractModuleDetector moduleDetector : this.moduleDetectors) {
            String[] relativeFileNames;
            for (String relativeFileName : relativeFileNames = this.factory.find(path, moduleDetector.getPattern())) {
                String relativePath = this.normalizePath(relativeFileName);
                if (relativePath.startsWith(SLASH)) {
                    absoluteFileNames.add(relativePath);
                    continue;
                }
                absoluteFileNames.add(new PathUtil().getAbsolutePath(path) + SLASH + relativePath);
            }
        }
        return absoluteFileNames;
    }

    private String normalizePath(String fileName) {
        return fileName.replace(BACK_SLASH, SLASH);
    }

    public static interface FileSystem {
        public String[] find(Path var1, String var2);

        @MustBeClosed
        public InputStream open(String var1) throws IOException, InvalidPathException;
    }
}

