/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.ModuleDetector;
import edu.hm.hafner.analysis.Report;
import java.util.List;
import java.util.stream.Collectors;

public class ModuleResolver {
    public void run(Report report, ModuleDetector detector) {
        List<Issue> issuesWithoutModule = report.stream().filter(issue -> !issue.hasModuleName()).collect(Collectors.toList());
        if (issuesWithoutModule.isEmpty()) {
            report.logInfo("-> all issues already have a valid module name", new Object[0]);
            return;
        }
        issuesWithoutModule.forEach(issue -> issue.setModuleName(detector.guessModuleName(issue.getAbsolutePath())));
        report.logInfo("-> resolved module names for %d issues", issuesWithoutModule.size());
    }
}

