/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.AbstractPackageDetector;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;

class PackageDetectors {
    static final String UNDEFINED_PACKAGE = "-";
    private final List<AbstractPackageDetector> detectors;

    @VisibleForTesting
    PackageDetectors(List<AbstractPackageDetector> detectors) {
        this.detectors = detectors;
    }

    public String detectPackageName(String fileName, Charset charset) {
        for (AbstractPackageDetector detector : this.detectors) {
            if (!detector.accepts(fileName)) continue;
            return detector.detectPackageName(fileName, charset);
        }
        return UNDEFINED_PACKAGE;
    }

    @VisibleForTesting
    static class FileSystem {
        FileSystem() {
        }

        @MustBeClosed
        InputStream openFile(String fileName) throws IOException, InvalidPathException {
            return Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
        }
    }
}

