/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractPackageDetector;
import edu.hm.hafner.analysis.CSharpNamespaceDetector;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.JavaPackageDetector;
import edu.hm.hafner.analysis.KotlinPackageDetector;
import edu.hm.hafner.analysis.PackageDetectors;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PackageNameResolver {
    private final PackageDetectors packageDetectors;

    public PackageNameResolver() {
        this(new PackageDetectors.FileSystem());
    }

    @VisibleForTesting
    PackageNameResolver(PackageDetectors.FileSystem fileSystem) {
        ArrayList<AbstractPackageDetector> detectors = new ArrayList<AbstractPackageDetector>(Arrays.asList(new JavaPackageDetector(fileSystem), new CSharpNamespaceDetector(fileSystem), new KotlinPackageDetector(fileSystem)));
        this.packageDetectors = new PackageDetectors(detectors);
    }

    public void run(Report report, Charset charset) {
        Set filesWithoutPackageName = report.stream().filter(issue -> !issue.hasPackageName()).map(Issue::getAbsolutePath).collect(Collectors.toSet());
        if (filesWithoutPackageName.isEmpty()) {
            report.logInfo("-> all affected files already have a valid package name", new Object[0]);
            return;
        }
        Map packagesOfFiles = filesWithoutPackageName.stream().collect(Collectors.toMap(Function.identity(), fileName -> this.packageDetectors.detectPackageName((String)fileName, charset)));
        try (IssueBuilder builder = new IssueBuilder();){
            report.stream().forEach(issue -> {
                if (!issue.hasPackageName()) {
                    issue.setPackageName(builder.internPackageName((String)packagesOfFiles.get(issue.getAbsolutePath())));
                }
            });
        }
        report.logInfo("-> resolved package names of %d affected files", filesWithoutPackageName.size());
    }
}

