/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.LookaheadParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMavenLogParser
extends LookaheadParser {
    private static final long serialVersionUID = -3768790896172545192L;
    private static final Pattern MAVEN_PLUGIN_START = Pattern.compile("\\[INFO\\] --- (?<id>\\S+):(?<version>\\S+):(?<goal>\\S+)\\s.*");
    private static final Pattern MAVEN_MODULE_START = Pattern.compile("-+< (?<id>\\S+) >-+");
    private static final String MAVEN_PLUGIN_PREFIX = "maven-";
    private static final String MAVEN_PLUGIN_SUFFIX = "-plugin";
    static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    static final String MAVEN_SUREFIRE_PLUGIN = "maven-surefire-plugin";
    static final String MAVEN_FAILSAFE_PLUGIN = "maven-failsafe-plugin";
    static final String MAVEN_JAVADOC_PLUGIN = "maven-javadoc-plugin";
    static final String MAVEN_HPI_PLUGIN = "maven-hpi-plugin";
    static final String MAVEN_ENFORCER_PLUGIN = "maven-enforcer-plugin";
    private String goal = "";
    private String module = "";

    protected AbstractMavenLogParser(String pattern) {
        super(pattern);
    }

    @Override
    protected void preprocessLine(String line) {
        Matcher goalMatcher = MAVEN_PLUGIN_START.matcher(line);
        if (goalMatcher.find()) {
            this.goal = String.format("%s:%s", goalMatcher.group("id"), goalMatcher.group("goal"));
        } else if (line.contains("[INFO] BUILD ")) {
            this.goal = "";
        }
        Matcher moduleMatcher = MAVEN_MODULE_START.matcher(line);
        if (moduleMatcher.find()) {
            this.module = moduleMatcher.group("id");
        }
    }

    protected String getModule() {
        return this.module;
    }

    protected String getGoal() {
        return this.goal;
    }

    boolean hasGoalOrModule() {
        return StringUtils.isNotBlank((CharSequence)this.goal) || StringUtils.isNotBlank((CharSequence)this.module);
    }

    protected boolean hasGoals(String ... goals) {
        for (String searchGoal : goals) {
            if (this.goal.contains(searchGoal)) {
                return true;
            }
            if (!this.goal.contains(StringUtils.removeEnd((String)StringUtils.removeStart((String)searchGoal, (String)MAVEN_PLUGIN_PREFIX), (String)MAVEN_PLUGIN_SUFFIX))) continue;
            return true;
        }
        return false;
    }
}

