/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class AnsibleLintParser
extends LookaheadParser {
    private static final long serialVersionUID = 8481090596321427484L;
    private static final String ANSIBLE_LINT_WARNING_PATTERN = "(?<file>.*)\\:(?<lineno>[0-9]*)\\:\\s*(\\[(?<cat>[a-zA-Z0-9\\-\\[\\]]+)\\]|(?<newcat>[^\\[][a-zA-Z0-9\\[\\]\\-]+)):?\\s(?<msg>.*)";

    public AnsibleLintParser() {
        super(ANSIBLE_LINT_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(":");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String cat = matcher.group("cat") != null ? matcher.group("cat") : matcher.group("newcat");
        return builder.setFileName(matcher.group("file")).setLineStart(matcher.group("lineno")).setCategory(cat).setMessage(matcher.group("msg")).buildOptional();
    }
}

