/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.DomContent;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class AquaScannerParser
extends JsonIssueParser {
    private static final String VALUE_NOT_SET = "-";
    private static final String AQUA_VULNERABILITY_LEVEL_TAG_HIGH = "high";
    private static final String AQUA_VULNERABILITY_LEVEL_TAG_MEDIUM = "medium";
    private static final String AQUA_VULNERABILITY_LEVEL_TAG_LOW = "low";
    private static final String AQUA_VULNERABILITY_LEVEL_TAG_NEGLIGIBLE = "negligible";
    private static final long serialVersionUID = 1L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray resources = jsonReport.optJSONArray("resources");
        if (resources != null) {
            this.parseResources(report, resources, issueBuilder);
        }
    }

    private void parseResources(Report report, JSONArray resources, IssueBuilder issueBuilder) {
        for (int i = 0; i < resources.length(); ++i) {
            JSONObject resourceWrapper;
            Object item = resources.get(i);
            if (!(item instanceof JSONObject) || (resourceWrapper = (JSONObject)item).isNull("vulnerabilities") || resourceWrapper.isNull("resource")) continue;
            JSONObject resource = resourceWrapper.getJSONObject("resource");
            this.parseVulnerabilities(report, issueBuilder, resourceWrapper, resource);
        }
    }

    private void parseVulnerabilities(Report report, IssueBuilder issueBuilder, JSONObject resourceWrapper, JSONObject resource) {
        JSONArray vulnerabilities = resourceWrapper.getJSONArray("vulnerabilities");
        for (Object vulnerability : vulnerabilities) {
            if (!(vulnerability instanceof JSONObject)) continue;
            report.add(this.convertToIssue(resource, (JSONObject)vulnerability, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject resource, JSONObject vulnerability, IssueBuilder issueBuilder) {
        String fileName = resource.optString("path", resource.optString("name", VALUE_NOT_SET));
        return issueBuilder.setFileName(fileName).setSeverity(this.mapSeverity(vulnerability.optString("aqua_severity", "UNKNOWN"))).setMessage(vulnerability.optString("name", "UNKNOWN")).setDescription(this.formatDescription(fileName, resource, vulnerability)).buildAndClean();
    }

    private Severity mapSeverity(String string) {
        if (StringUtils.containsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{AQUA_VULNERABILITY_LEVEL_TAG_LOW, AQUA_VULNERABILITY_LEVEL_TAG_NEGLIGIBLE})) {
            return Severity.WARNING_LOW;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)AQUA_VULNERABILITY_LEVEL_TAG_MEDIUM)) {
            return Severity.WARNING_NORMAL;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)AQUA_VULNERABILITY_LEVEL_TAG_HIGH)) {
            return Severity.WARNING_HIGH;
        }
        return Severity.ERROR;
    }

    private String formatDescription(String fileName, JSONObject resource, JSONObject vulnerability) {
        String version = resource.optString("version", VALUE_NOT_SET);
        String severity = vulnerability.optString("aqua_severity", "UNKOWN");
        String description = vulnerability.optString("description", "");
        return TagCreator.join((Object[])new Object[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Resource: "), TagCreator.text((String)fileName)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Installed Version: "), TagCreator.text((String)version)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Aqua Severity: "), TagCreator.text((String)severity)}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)description)})}).render();
    }
}

