/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class CrossCoreEmbeddedStudioParser
extends LookaheadParser {
    private static final long serialVersionUID = 1L;
    private static final String CCES_WARNING_PATTERN = "^\"(?<file>.+?)\", line (?<line>\\d+).*(?<category>cc\\d+).*warning:(?<messageBegin>.*)";

    public CrossCoreEmbeddedStudioParser() {
        super(CCES_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        StringBuilder message = new StringBuilder(matcher.group("messageBegin").trim());
        if (lookahead.hasNext()) {
            message.append(" ");
            message.append(lookahead.next().trim());
        }
        return builder.setFileName(matcher.group("file")).setLineStart(matcher.group("line")).setSeverity(Severity.WARNING_NORMAL).setCategory(matcher.group("category")).setMessage(message.toString()).buildOptional();
    }
}

