/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class DockerLintParser
extends JsonIssueParser {
    private static final long serialVersionUID = -4077698163775928314L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        for (String severityGroupName : jsonReport.keySet()) {
            Object severityGroup = jsonReport.get(severityGroupName);
            if (!(severityGroup instanceof JSONObject)) continue;
            JSONArray data = ((JSONObject)severityGroup).optJSONArray("data");
            for (Object issue : data) {
                if (!(issue instanceof JSONObject)) continue;
                report.add(this.convertToIssue((JSONObject)issue, issueBuilder));
            }
        }
    }

    private Issue convertToIssue(JSONObject jsonIssue, IssueBuilder builder) {
        StringBuilder message = new StringBuilder();
        message.append(jsonIssue.optString("message"));
        if (jsonIssue.has("description")) {
            message.append(" - ");
            message.append(jsonIssue.getString("description"));
        }
        if (jsonIssue.has("reference_url")) {
            Object refUrl = jsonIssue.get("reference_url");
            message.append(" See ");
            message.append(this.collapseReferenceUrl(refUrl));
        }
        builder.setMessage(message.toString());
        builder.setSeverity(this.toSeverity(jsonIssue.optString("level")));
        builder.setLineStart(jsonIssue.optInt("line", -1));
        builder.setCategory(jsonIssue.optString("label", null));
        builder.setFileName("Dockerfile");
        return builder.buildAndClean();
    }

    private String collapseReferenceUrl(Object refUrl) {
        StringBuilder referenceUrl = new StringBuilder();
        if (refUrl instanceof JSONArray) {
            for (Object part : (JSONArray)refUrl) {
                referenceUrl.append(part);
            }
        } else {
            referenceUrl.append(refUrl);
        }
        return referenceUrl.toString();
    }

    private Severity toSeverity(String level) {
        switch (level) {
            case "warn": {
                return Severity.WARNING_NORMAL;
            }
            case "error": {
                return Severity.WARNING_HIGH;
            }
        }
        return Severity.WARNING_LOW;
    }
}

