/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.parser.EclipseParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class EclipseMavenParser
extends LookaheadParser {
    private static final long serialVersionUID = 425883472788422955L;
    private static final String ECLIPSE_FIRST_LINE_REGEXP = "\\s*\\[(?<severity>WARNING|ERROR|INFO)\\]\\s*(?<file>.*):\\[(?<line>\\d+)(?:,\\d+)?\\]\\s*(?<message>.*)";

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return !this.isXmlFile(readerFactory);
    }

    public EclipseMavenParser() {
        super(ECLIPSE_FIRST_LINE_REGEXP);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("WARNING") || line.contains("ERROR") || line.contains("INFO");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        builder.guessSeverity(matcher.group("severity")).setFileName(matcher.group("file")).setLineStart(matcher.group("line"));
        String message = matcher.group("message");
        if (StringUtils.isNotBlank((CharSequence)message)) {
            builder.setMessage(message);
            EclipseParser.extractCategory(builder, message);
        } else {
            ArrayList<String> code = new ArrayList<String>();
            while (lookahead.hasNext("^\\t.*$") && lookahead.hasNext()) {
                code.add(lookahead.next());
            }
            builder.setAdditionalProperties(Integer.valueOf(code.hashCode()));
            if (lookahead.hasNext()) {
                EclipseParser.extractMessage(builder, RegExUtils.removeFirst((String)lookahead.next(), (String)".*\\t"));
            }
        }
        return builder.buildOptional();
    }
}

