/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.util.LookaheadStream;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ErrorProneParser
extends LookaheadParser {
    private static final long serialVersionUID = 8434408068719510740L;
    private static final Pattern URL_PATTERN = Pattern.compile("\\s+\\(see (?<url>http\\S+)\\s*\\)");
    private static final Pattern FIX_PATTERN = Pattern.compile("\\s+Did you mean '(?<code>.*)'\\?");
    private static final String WARNINGS_PATTERN = "^(?:\\[\\p{Alnum}*\\]\\s+)?\\[(?<severity>WARNING|ERROR)\\]\\s+(?<file>.+):\\[(?<line>\\d+)(?:,(?<column>\\d+))?\\]\\s+\\[(?<type>\\w+)\\]\\s+(?<message>.*)";
    private static final String SEE_ERROR_PRONE_DOCUMENTATION = "See ErrorProne documentation.";

    public ErrorProneParser() {
        super(WARNINGS_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        String description = ErrorProneParser.createDescription(lookahead);
        if (description.contains(SEE_ERROR_PRONE_DOCUMENTATION)) {
            builder.setFileName(matcher.group("file")).setLineStart(matcher.group("line")).setColumnStart(matcher.group("column")).setType(matcher.group("type")).setMessage(ErrorProneParser.appendPeriod(matcher)).guessSeverity(matcher.group("severity")).setDescription(description);
            return builder.buildOptional();
        }
        return Optional.empty();
    }

    static String appendPeriod(Matcher matcher) {
        return StringUtils.appendIfMissing((String)matcher.group("message"), (CharSequence)".", (CharSequence[])new CharSequence[0]);
    }

    static String createDescription(LookaheadStream lookahead) {
        StringBuilder description = new StringBuilder();
        StringBuilder url = new StringBuilder();
        boolean urlFound = false;
        while (lookahead.hasNext("^\\s+.*")) {
            String line = lookahead.next();
            Matcher urlMatcher = URL_PATTERN.matcher(line);
            if (urlMatcher.matches()) {
                url.append(TagCreator.p().with((DomContent)((ContainerTag)TagCreator.a().withHref(urlMatcher.group("url"))).withText(SEE_ERROR_PRONE_DOCUMENTATION)).render());
                urlFound = true;
                continue;
            }
            Matcher fixMatcher = FIX_PATTERN.matcher(line);
            if (fixMatcher.matches()) {
                description.append("Did you mean: ");
                description.append(TagCreator.pre().with((DomContent)TagCreator.code().withText(fixMatcher.group("code"))).render());
                continue;
            }
            if (!urlFound) continue;
            description.append(line);
        }
        return description.toString() + String.valueOf(url);
    }
}

