/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Gcc4CompilerParser
extends LookaheadParser {
    private static final long serialVersionUID = 5490211629355204910L;
    private static final String GCC_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*(.+?):(\\d+):(?:(\\d+):)? ?([wW]arning|.*[Ee]rror): (.*)$";
    private static final Pattern CLASS_PATTERN = Pattern.compile("\\[-W(.+)]$");

    public Gcc4CompilerParser() {
        super(GCC_WARNING_PATTERN);
    }

    Gcc4CompilerParser(String pattern) {
        super(pattern);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("arning") || line.contains("rror");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        StringBuilder message = new StringBuilder(matcher.group(5));
        Matcher classMatcher = CLASS_PATTERN.matcher(message.toString());
        if (classMatcher.find() && classMatcher.group(1) != null) {
            builder.setCategory(classMatcher.group(1));
        }
        while (lookahead.hasNext() && this.isMessageContinuation(lookahead)) {
            message.append('\n');
            message.append(lookahead.next());
        }
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setColumnStart(matcher.group(3)).setMessage(message.toString()).setSeverity(Severity.guessFromString(matcher.group(4))).buildOptional();
    }

    private boolean isMessageContinuation(LookaheadStream lookahead) {
        String peek = lookahead.peekNext();
        if (peek.length() < 3) {
            return false;
        }
        if (peek.charAt(0) == '/' || peek.charAt(0) == '[' || peek.charAt(0) == '<' || peek.charAt(0) == '=') {
            return false;
        }
        if (peek.charAt(1) == ':') {
            return false;
        }
        if (peek.charAt(2) == '/' || peek.charAt(0) == '\\') {
            return false;
        }
        return !StringUtils.containsAnyIgnoreCase((CharSequence)peek, (CharSequence[])new CharSequence[]{"arning", "rror", "make"});
    }
}

