/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import org.json.JSONArray;
import org.json.JSONObject;

public class GrypeParser
extends JsonIssueParser {
    private static final long serialVersionUID = -1369431674771459756L;
    private static final String MATCHES_TAG = "matches";
    private static final String VULNERABILIY_TAG = "vulnerability";
    private static final String ARTIFACT_TAG = "artifact";
    private static final String LOCATIONS_TAG = "locations";
    private static final String PATH_TAG = "path";
    private static final String DATA_SOURCE_TAG = "dataSource";
    private static final String SEVERITY_TAG = "severity";
    private static final String ID_TAG = "id";
    private static final String DESCRIPTION_TAG = "description";
    private static final String NAME_TAG = "name";
    private static final String VERSION_TAG = "version";
    private static final String TYPE_TAG = "type";

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray matches = jsonReport.getJSONArray(MATCHES_TAG);
        for (int i = 0; i < matches.length(); ++i) {
            JSONObject match = matches.getJSONObject(i);
            if (!match.has(VULNERABILIY_TAG)) continue;
            Issue issue = this.getIssue(issueBuilder, match);
            report.add(issue);
        }
    }

    private Issue getIssue(IssueBuilder issueBuilder, JSONObject match) {
        JSONObject vuln = match.getJSONObject(VULNERABILIY_TAG);
        JSONObject artifact = match.getJSONObject(ARTIFACT_TAG);
        String fileName = artifact.getJSONArray(LOCATIONS_TAG).getJSONObject(0).getString(PATH_TAG);
        Object packageName = artifact.optString(NAME_TAG, "Unknown");
        String version = artifact.optString(VERSION_TAG, "");
        if (!version.isEmpty()) {
            packageName = (String)packageName + " " + version;
        }
        return issueBuilder.setFileName(fileName).setPackageName((String)packageName).setCategory(artifact.optString(TYPE_TAG, "Unknown")).setSeverity(Severity.guessFromString(vuln.getString(SEVERITY_TAG))).setType(vuln.getString(ID_TAG)).setMessage(vuln.optString(DESCRIPTION_TAG, "Unknown")).setOriginName("Grype").setPathName(fileName).setDescription(TagCreator.p().with((DomContent)((ContainerTag)TagCreator.a().withHref(vuln.getString(DATA_SOURCE_TAG))).withText(vuln.getString(DATA_SOURCE_TAG))).render()).build();
    }
}

