/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class IarParser
extends LookaheadParser {
    private static final long serialVersionUID = 7695540852439013425L;
    static final String IAR_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*(?:\"?(.*?)\"?[\\(,](\\d+)\\)?\\s+(?::\\s)?)?(Error|Remark|Warning|Fatal [Ee]rror)\\[(\\w+)\\]: (.*)$";

    public IarParser() {
        super(IAR_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("Warning") || line.contains("rror") || line.contains("Remark");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        return builder.setSeverity(this.mapPriority(matcher)).setMessage(this.normalizeWhitespaceInMessage(matcher.group(5))).setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(matcher.group(4)).buildOptional();
    }

    private Severity mapPriority(Matcher matcher) {
        Severity priority = IarParser.equalsIgnoreCase(matcher.group(3), "Remark") ? Severity.WARNING_LOW : (IarParser.equalsIgnoreCase(matcher.group(3), "Error") ? Severity.ERROR : (IarParser.equalsIgnoreCase(matcher.group(3), "Fatal error") ? Severity.ERROR : Severity.WARNING_NORMAL));
        return priority;
    }

    private String normalizeWhitespaceInMessage(String message) {
        return message.replaceAll("\\s+", " ");
    }
}

