/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.Severity;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class JsonBaseParser
extends IssueParser {
    private static final long serialVersionUID = -2318844382394973833L;

    JsonBaseParser() {
    }

    Optional<Issue> convertToIssue(JSONObject jsonIssue) {
        try (IssueBuilder builder = new IssueBuilder();){
            Optional<Issue> optional = this.convertToIssue(jsonIssue, builder);
            return optional;
        }
    }

    Optional<Issue> convertToIssue(JSONObject jsonIssue, IssueBuilder builder) {
        if (jsonIssue.has("additionalProperties")) {
            builder.setAdditionalProperties((Serializable)((Object)jsonIssue.getString("additionalProperties")));
        }
        if (jsonIssue.has("category")) {
            builder.setCategory(jsonIssue.getString("category"));
        }
        if (jsonIssue.has("columnEnd")) {
            builder.setColumnEnd(jsonIssue.getInt("columnEnd"));
        }
        if (jsonIssue.has("columnStart")) {
            builder.setColumnStart(jsonIssue.getInt("columnStart"));
        }
        if (jsonIssue.has("description")) {
            builder.setDescription(jsonIssue.getString("description"));
        }
        if (jsonIssue.has("fingerprint")) {
            builder.setFingerprint(jsonIssue.getString("fingerprint"));
        }
        if (jsonIssue.has("fileName")) {
            builder.setFileName(jsonIssue.getString("fileName"));
        }
        if (jsonIssue.has("id")) {
            builder.setId(UUID.fromString(jsonIssue.getString("id")));
        }
        if (jsonIssue.has("lineEnd")) {
            builder.setLineEnd(jsonIssue.getInt("lineEnd"));
        }
        if (jsonIssue.has("lineRanges")) {
            JSONArray jsonRanges = jsonIssue.getJSONArray("lineRanges");
            LineRangeList lineRanges = this.convertToLineRangeList(jsonRanges);
            builder.setLineRanges(lineRanges);
        }
        if (jsonIssue.has("lineStart")) {
            builder.setLineStart(jsonIssue.getInt("lineStart"));
        }
        if (jsonIssue.has("message")) {
            builder.setMessage(jsonIssue.getString("message"));
        }
        if (jsonIssue.has("moduleName")) {
            builder.setModuleName(jsonIssue.getString("moduleName"));
        }
        if (jsonIssue.has("origin")) {
            builder.setOrigin(jsonIssue.getString("origin"));
        }
        if (jsonIssue.has("packageName")) {
            builder.setPackageName(jsonIssue.getString("packageName"));
        }
        if (jsonIssue.has("severity")) {
            builder.setSeverity(Severity.valueOf(jsonIssue.getString("severity")));
        }
        if (jsonIssue.has("type")) {
            builder.setType(jsonIssue.getString("type"));
        }
        return builder.buildOptional();
    }

    private LineRangeList convertToLineRangeList(JSONArray jsonRanges) {
        LineRangeList lineRanges = new LineRangeList();
        for (int i = 0; i < jsonRanges.length(); ++i) {
            JSONObject jsonRange = jsonRanges.getJSONObject(i);
            if (jsonRange.has("start")) {
                if (jsonRange.has("end")) {
                    lineRanges.add(new LineRange(jsonRange.getInt("start"), jsonRange.getInt("end")));
                    continue;
                }
                lineRanges.add(new LineRange(jsonRange.getInt("start")));
                continue;
            }
            if (!jsonRange.has("end")) continue;
            lineRanges.add(new LineRange(jsonRange.getInt("end"), jsonRange.getInt("end")));
        }
        return lineRanges;
    }
}

