/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MentorParser
extends LookaheadParser {
    public static final long serialVersionUID = 1L;
    private static final String MSG_REGEX = "\\*\\*\\s+(?<priority>[\\w \\(\\)]+):\\s+(?<message>.*)";
    private static final Pattern VSIM_PATTERN = Pattern.compile("\\((?<category>v\\w+-\\d+)\\)(?: (?<filename>\\S*)\\((?<line>\\d+)\\):)? (?<message>.*)");
    private static final Pattern VLOG_FILE_PATTERN = Pattern.compile("(?<filename>\\S*)\\((?<line>\\d+)\\):");
    private static final Pattern VLOG_TYPE_PATTERN = Pattern.compile("\\((?<category>v\\w+-\\d+)\\) (?<message>.*)");
    private static final Pattern TIME_FILE_PATTERN = Pattern.compile("# {4}Time: (?<simtime>\\d* \\ws)(?: {2}Iteration: \\d+)? {2}\\w*: (?<module>.\\S*)(?: File: (?<filename>\\S+))?(?: Line: (?<line>\\d+))?.*");

    public MentorParser() {
        super(MSG_REGEX);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        this.clearBuilder(builder);
        builder.guessSeverity(matcher.group("priority"));
        String message = matcher.group("message");
        if (message.contains("while parsing file")) {
            this.parseLongVlogMessage(lookahead, builder);
        } else if (message.contains("vlog-") || message.contains("vopt-")) {
            this.parseVlogMessage(builder, message);
        } else {
            this.parseVsimMessage(lookahead, builder, message);
        }
        return builder.buildOptional();
    }

    private void parseLongVlogMessage(LookaheadStream lookahead, IssueBuilder builder) {
        while (!lookahead.peekNext().startsWith("# ** at ")) {
            lookahead.next();
        }
        this.parseVlogMessage(builder, lookahead.next().substring(8));
    }

    private void parseVlogMessage(IssueBuilder builder, String message) {
        String parsedMessage = message;
        builder.setCategory("vlog");
        Matcher vlog = VLOG_FILE_PATTERN.matcher(message);
        if (vlog.find()) {
            builder.setFileName(vlog.group("filename"));
            builder.setLineStart(vlog.group("line"));
        }
        if ((vlog = VLOG_TYPE_PATTERN.matcher(message)).find()) {
            builder.setCategory(vlog.group("category"));
            parsedMessage = vlog.group("message");
        }
        builder.setDescription("");
        builder.setMessage(parsedMessage);
    }

    private void parseVsimMessage(LookaheadStream lookahead, IssueBuilder builder, String message) {
        builder.setDescription(this.parseSimTime(lookahead, builder));
        String parsedMessage = message;
        Matcher vsim = VSIM_PATTERN.matcher(message);
        if (vsim.matches()) {
            builder.setCategory(vsim.group("category"));
            builder.setFileName(vsim.group("filename"));
            builder.setLineStart(vsim.group("line"));
            parsedMessage = vsim.group("message");
        }
        builder.setMessage(parsedMessage);
    }

    private String parseSimTime(LookaheadStream lookahead, IssueBuilder builder) {
        StringBuilder description = new StringBuilder();
        String timeLine = "";
        while (lookahead.hasNext() && lookahead.peekNext().startsWith("# ") && !lookahead.peekNext().startsWith("# **") && !(timeLine = lookahead.next()).startsWith("#    Time:")) {
            description.append("<br>");
            description.append(timeLine);
        }
        Matcher tf = TIME_FILE_PATTERN.matcher(timeLine);
        if (tf.matches()) {
            builder.setModuleName(tf.group("module"));
            builder.setFileName(tf.group("filename"));
            builder.setLineStart(tf.group("line"));
        }
        return description.toString();
    }

    private void clearBuilder(IssueBuilder builder) {
        builder.setModuleName(null);
        builder.setFileName(null);
        builder.setLineStart(null);
        builder.setCategory("-");
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.startsWith("# ** ") || line.startsWith("** ");
    }
}

