/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class MetrowerksCwCompilerParser
extends LookaheadParser {
    private static final long serialVersionUID = 4317595592384426180L;
    private static final String CW_COMPILER_WARNING_PATTERN = "^(.+?)\\((\\d+)\\): (INFORMATION|WARNING|ERROR) (.+?): (.*)$";

    public MetrowerksCwCompilerParser() {
        super(CW_COMPILER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String category;
        Severity priority;
        if (MetrowerksCwCompilerParser.equalsIgnoreCase(matcher.group(3), "error")) {
            priority = Severity.WARNING_HIGH;
            category = "ERROR";
        } else if (MetrowerksCwCompilerParser.equalsIgnoreCase(matcher.group(3), "information")) {
            priority = Severity.WARNING_LOW;
            category = "Info";
        } else {
            priority = Severity.WARNING_NORMAL;
            category = "Warning";
        }
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(category).setMessage(matcher.group(5)).setSeverity(priority).buildOptional();
    }
}

