/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MsBuildParser
extends LookaheadParser {
    private static final long serialVersionUID = -2141974437420906595L;
    private static final String MS_BUILD_WARNING_PATTERN = "(?:^(?:.*)Command line warning ([A-Za-z0-9]+):\\s*(.*)\\s*\\[(.*)\\])|^(?:.*\\[[^]]*\\])?\\s*(?:(?:\\s*(?:\\d+|\\d+:\\d+)>)?(?:(?:(?:(.*?)\\((\\d*)(?:,(\\d+))?[a-zA-Z]*?\\)|.*LINK)\\s*:|(.*):)\\s*([A-z-_]*\\s(?:[Nn]ote|[Ii]nfo|[Ww]arning|(?:fatal\\s*)?[Ee]rror))[^A-Za-z0-9]\\s*:?\\s*([A-Za-z0-9\\-_]+)?\\s*:\\s(?:\\s*([A-Za-z0-9.]+)\\s*:)?\\s*(.*?)(?: \\[([^\\]]*)[/\\\\][^\\]\\\\]+\\])?))$";
    private static final Pattern IGNORED_TOOLS_PATTERN = Pattern.compile("(?!.exe)(\\.[^.]+)$");
    private static final Pattern LINKER_CAUSE = Pattern.compile(".*imported by '([A-Za-z0-9\\-_.]+)'.*");

    public MsBuildParser() {
        super(MS_BUILD_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String fileName = this.determineFileName(matcher);
        Matcher fileExtensionMatcher = IGNORED_TOOLS_PATTERN.matcher(fileName);
        if (!fileExtensionMatcher.find()) {
            return Optional.empty();
        }
        builder.setFileName(fileName);
        if (StringUtils.isNotBlank((CharSequence)matcher.group(2))) {
            return builder.setLineStart(0).setCategory(matcher.group(1)).setMessage(matcher.group(2)).setSeverity(Severity.WARNING_NORMAL).buildOptional();
        }
        if (StringUtils.isNotEmpty((CharSequence)matcher.group(10))) {
            return builder.setLineStart(matcher.group(5)).setColumnStart(matcher.group(6)).setCategory(matcher.group(9)).setType(matcher.group(10)).setMessage(matcher.group(11)).setSeverity(Severity.guessFromString(matcher.group(8))).buildOptional();
        }
        String category = matcher.group(9);
        if ("Expected".equals(category)) {
            return Optional.empty();
        }
        return builder.setLineStart(matcher.group(5)).setColumnStart(matcher.group(6)).setCategory(category).setMessage(matcher.group(11)).setSeverity(Severity.guessFromString(matcher.group(8))).buildOptional();
    }

    private String determineFileName(Matcher matcher) {
        String projectDir;
        Matcher linker;
        String fileName = StringUtils.isNotBlank((CharSequence)matcher.group(3)) ? matcher.group(3) : (StringUtils.isNotBlank((CharSequence)matcher.group(7)) ? matcher.group(7) : matcher.group(4));
        if (StringUtils.isBlank((CharSequence)fileName) && (linker = LINKER_CAUSE.matcher(matcher.group(11))).matches()) {
            return linker.group(1);
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = StringUtils.substringBetween((String)matcher.group(11), (String)"'");
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "unknown.file";
        }
        if (this.canResolveRelativeFileName(fileName, projectDir = matcher.group(12))) {
            fileName = FilenameUtils.concat((String)projectDir, (String)fileName);
        }
        if ("MSBUILD".equals(fileName.trim())) {
            fileName = "-";
        }
        return fileName;
    }

    private boolean canResolveRelativeFileName(String fileName, String projectDir) {
        return StringUtils.isNotBlank((CharSequence)projectDir) && FilenameUtils.getPrefixLength((String)fileName) == 0 && !"MSBUILD".equals(fileName.trim());
    }
}

