/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import j2html.TagCreator;
import j2html.tags.DomContent;
import org.json.JSONArray;
import org.json.JSONObject;

public class TrivyParser
extends JsonIssueParser {
    private static final String VALUE_NOT_SET = "-";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_HIGH = "high";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_MEDIUM = "medium";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_LOW = "low";
    private static final long serialVersionUID = 1L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray results = jsonReport.optJSONArray("Results");
        if (results != null) {
            this.parseResults(report, results, issueBuilder);
        }
    }

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        this.parseResults(report, jsonReport, issueBuilder);
    }

    private void parseResults(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (int i = 0; i < jsonReport.length(); ++i) {
            JSONObject component = (JSONObject)jsonReport.get(i);
            if (component.isNull("Vulnerabilities")) continue;
            JSONArray vulnerabilities = component.getJSONArray("Vulnerabilities");
            for (Object vulnerability : vulnerabilities) {
                report.add(this.convertToIssue((JSONObject)vulnerability, issueBuilder));
            }
        }
    }

    private Issue convertToIssue(JSONObject vulnerability, IssueBuilder issueBuilder) {
        return issueBuilder.setFileName(vulnerability.optString("PkgName", VALUE_NOT_SET)).setCategory(vulnerability.optString("SeveritySource", VALUE_NOT_SET)).setSeverity(this.mapSeverity(vulnerability.optString("Severity", "UNKNOWN"))).setType(vulnerability.optString("VulnerabilityID", VALUE_NOT_SET)).setMessage(vulnerability.optString("Title", "UNKNOWN")).setDescription(this.formatDescription(vulnerability)).buildAndClean();
    }

    @SuppressFBWarnings(value={"IMPROPER_UNICODE"})
    private Severity mapSeverity(String string) {
        if (TRIVY_VULNERABILITY_LEVEL_TAG_LOW.equalsIgnoreCase(string)) {
            return Severity.WARNING_LOW;
        }
        if (TRIVY_VULNERABILITY_LEVEL_TAG_MEDIUM.equalsIgnoreCase(string)) {
            return Severity.WARNING_NORMAL;
        }
        if (TRIVY_VULNERABILITY_LEVEL_TAG_HIGH.equalsIgnoreCase(string)) {
            return Severity.WARNING_HIGH;
        }
        return Severity.ERROR;
    }

    private String formatDescription(JSONObject vulnerability) {
        String fileName = vulnerability.optString("PkgName", VALUE_NOT_SET);
        String installedVersion = vulnerability.optString("InstalledVersion", VALUE_NOT_SET);
        String fixedVersion = vulnerability.optString("FixedVersion", "still open");
        String severity = vulnerability.optString("Severity", "UNKOWN");
        String description = vulnerability.optString("Description", "");
        return TagCreator.join((Object[])new Object[]{TagCreator.p((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"File: "), TagCreator.text((String)fileName)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Installed Version: "), TagCreator.text((String)installedVersion)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Fixed Version: "), TagCreator.text((String)fixedVersion)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Severity: "), TagCreator.text((String)severity)}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)description)})})}).render();
    }
}

