/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.findbugs;

import edu.hm.hafner.analysis.SecureDigester;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public final class FindBugsMessages {
    private static final String NO_MESSAGE_FOUND = "no message found";
    private final Map<String, String> messages = new HashMap<String, String>();
    private final Map<String, String> shortMessages = new HashMap<String, String>();

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public FindBugsMessages() {
        try {
            this.loadMessages("messages.xml", this.messages, this.shortMessages);
            this.loadMessages("fb-contrib-messages.xml", this.messages, this.shortMessages);
            this.loadMessages("find-sec-bugs-messages.xml", this.messages, this.shortMessages);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadMessages(String fileName, Map<String, String> messagesCache, Map<String, String> shortMessagesCache) throws IOException, SAXException {
        try (InputStream file = FindBugsMessages.class.getResourceAsStream(fileName);){
            List<Pattern> patterns = this.parse(file);
            for (Pattern pattern : patterns) {
                messagesCache.put(pattern.getType(), pattern.getDescription());
                shortMessagesCache.put(pattern.getType(), pattern.getShortDescription());
            }
        }
    }

    public List<Pattern> parse(InputStream file) throws IOException, SAXException {
        SecureDigester digester = new SecureDigester(FindBugsMessages.class);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        digester.push(patterns);
        String startPattern = "*/BugPattern";
        digester.addObjectCreate(startPattern, Pattern.class);
        digester.addSetProperties(startPattern);
        digester.addCallMethod("*/BugPattern/Details", "setDescription", 0);
        digester.addCallMethod("*/BugPattern/ShortDescription", "setShortDescription", 0);
        digester.addSetNext(startPattern, "add");
        digester.parse(file);
        return patterns;
    }

    public String getMessage(String name) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.messages.get(name), (CharSequence)NO_MESSAGE_FOUND);
    }

    public String getShortMessage(String name) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.shortMessages.get(name), (CharSequence)NO_MESSAGE_FOUND);
    }

    public int size() {
        return this.messages.size();
    }

    public static class Pattern {
        @CheckForNull
        private String type;
        @CheckForNull
        private String description;
        @CheckForNull
        private String shortDescription;

        public String getType() {
            return StringUtils.defaultString((String)this.type);
        }

        public void setType(@CheckForNull String type) {
            this.type = type;
        }

        public String getDescription() {
            return StringUtils.defaultString((String)this.description);
        }

        public void setDescription(@CheckForNull String description) {
            this.description = description;
        }

        public String getShortDescription() {
            return StringUtils.defaultString((String)this.shortDescription);
        }

        public void setShortDescription(@CheckForNull String shortDescription) {
            this.shortDescription = shortDescription;
        }
    }
}

