/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pvsstudio;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.pvsstudio.AnalyzerType;
import edu.hm.hafner.analysis.parser.pvsstudio.PlogMessage;
import java.util.List;

public class PVSStudioParser
extends IssueParser {
    private static final long serialVersionUID = -7777775729854832128L;

    private static Severity getSeverity(String level) {
        if ("1".equals(level)) {
            return Severity.WARNING_HIGH;
        }
        if ("2".equals(level)) {
            return Severity.WARNING_NORMAL;
        }
        if ("3".equals(level)) {
            return Severity.WARNING_LOW;
        }
        return Severity.ERROR;
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            List<PlogMessage> plogMessages = PlogMessage.getMessagesFromReport(readerFactory);
            Report report = new Report();
            for (PlogMessage plogMessage : plogMessages) {
                issueBuilder.setFileName(plogMessage.getFilePath());
                issueBuilder.setSeverity(PVSStudioParser.getSeverity(plogMessage.getLevel()));
                issueBuilder.setMessage(plogMessage.toString());
                issueBuilder.setCategory(plogMessage.getType());
                issueBuilder.setType(AnalyzerType.fromErrorCode(plogMessage.getType()).getMessage());
                issueBuilder.setLineStart(plogMessage.getLine());
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            return report2;
        }
    }
}

