/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.violations.AbstractViolationAdapter;
import java.util.stream.Stream;
import se.bjurr.violations.lib.parsers.JUnitParser;

public class JUnitAdapter
extends AbstractViolationAdapter {
    private static final long serialVersionUID = -1595503635554896281L;
    public static final String TOTAL_TESTS = "totalTests";
    public static final String PASSED_TESTS = "passedTests";
    public static final String FAILED_TESTS = "failedTests";
    public static final String SKIPPED_TESTS = "skippedTests";

    JUnitParser createParser() {
        return new JUnitParser();
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingCanceledException, ParsingException {
        Report report = super.parse(readerFactory);
        int total = this.count(readerFactory, "<testcase");
        report.setCounter(TOTAL_TESTS, total);
        int skipped = this.count(readerFactory, "<skipped");
        report.setCounter(SKIPPED_TESTS, skipped);
        report.setCounter(FAILED_TESTS, report.size());
        report.setCounter(PASSED_TESTS, total - skipped - report.size());
        return report;
    }

    private int count(ReaderFactory readerFactory, String text) {
        try (Stream<String> lines = readerFactory.readStream();){
            int n = Math.toIntExact(lines.filter(line -> line.contains(text)).count());
            return n;
        }
    }
}

