/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.violations.AbstractViolationAdapter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import j2html.TagCreator;
import j2html.attributes.Attr;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.DomContentJoiner;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ValgrindParser;

public class ValgrindAdapter
extends AbstractViolationAdapter {
    private static final long serialVersionUID = -6117336551972081612L;
    private static final int NUMBERED_STACK_THRESHOLD = 2;
    private static final int NO_LINE = -1;

    ValgrindParser createParser() {
        return new ValgrindParser();
    }

    @Override
    Report convertToReport(Set<Violation> violations) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            for (Violation violation : violations) {
                this.updateIssueBuilder(violation, issueBuilder);
                issueBuilder.setCategory("valgrind:" + violation.getReporter());
                issueBuilder.setDescription(this.generateDescriptionHtml(violation));
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            return report2;
        }
    }

    private String generateDescriptionHtml(Violation violation) {
        Map specifics = violation.getSpecifics();
        JSONArray auxWhats = this.getAuxWhatsArray(specifics);
        return DomContentJoiner.join((CharSequence)"", (boolean)false, (Object[])new Object[]{this.generateGeneralTableHtml(violation.getSource(), violation.getGroup(), (String)specifics.get("tid"), (String)specifics.get("threadname"), auxWhats), this.maybeGenerateStackTracesHtml((String)specifics.get("stacks"), violation.getMessage(), auxWhats), this.maybeGenerateSuppressionHtml((String)specifics.get("suppression"))}).render();
    }

    private ContainerTag generateGeneralTableHtml(String executable, String uniqueId, @CheckForNull String threadId, @CheckForNull String threadName, @CheckForNull JSONArray auxWhats) {
        ContainerTag generalTable = TagCreator.table((Attr.ShortForm)TagCreator.attrs((String)".table.table-striped"), (DomContent[])new DomContent[]{this.maybeGenerateTableRowHtml("Executable", executable), this.maybeGenerateTableRowHtml("Unique Id", uniqueId), this.maybeGenerateTableRowHtml("Thread Id", threadId), this.maybeGenerateTableRowHtml("Thread Name", threadName)});
        if (auxWhats != null && !auxWhats.isEmpty()) {
            for (int auxwhatIndex = 0; auxwhatIndex < auxWhats.length(); ++auxwhatIndex) {
                generalTable.with((DomContent)this.maybeGenerateTableRowHtml("Auxiliary", auxWhats.getString(auxwhatIndex)));
            }
        }
        return generalTable;
    }

    @CheckForNull
    private ContainerTag maybeGenerateStackTracesHtml(@CheckForNull String stacksJson, String message, @CheckForNull JSONArray auxWhats) {
        if (StringUtils.isBlank((CharSequence)stacksJson)) {
            return null;
        }
        JSONArray stacks = new JSONArray(new JSONTokener(stacksJson));
        if (!stacks.isEmpty()) {
            ContainerTag stackTraces = TagCreator.div();
            stackTraces.with((DomContent)this.generateStackTraceHtml("Primary Stack Trace", message, stacks.getJSONArray(0)));
            for (int stackIndex = 1; stackIndex < stacks.length(); ++stackIndex) {
                String msg = null;
                if (auxWhats != null && auxWhats.length() >= stackIndex) {
                    msg = auxWhats.getString(stackIndex - 1);
                }
                Object title = "Auxiliary Stack Trace";
                if (stacks.length() > 2) {
                    title = (String)title + " #" + stackIndex;
                }
                stackTraces.with((DomContent)this.generateStackTraceHtml((String)title, msg, stacks.getJSONArray(stackIndex)));
            }
            return stackTraces;
        }
        return null;
    }

    private ContainerTag generateStackTraceHtml(String title, @CheckForNull String message, JSONArray frames) {
        ContainerTag stackTraceContainer = TagCreator.div((DomContent[])new DomContent[]{TagCreator.br(), TagCreator.h4((String)title), (DomContent)TagCreator.iff((boolean)StringUtils.isNotBlank((CharSequence)message), (Object)TagCreator.p((String)message))});
        for (int frameIndex = 0; frameIndex < frames.length(); ++frameIndex) {
            JSONObject frame = frames.getJSONObject(frameIndex);
            if (frameIndex > 0) {
                stackTraceContainer.with((DomContent)TagCreator.br());
            }
            stackTraceContainer.with((DomContent)this.generateStackFrameHtml(frame));
        }
        return stackTraceContainer;
    }

    private ContainerTag generateStackFrameHtml(JSONObject frame) {
        return TagCreator.table((DomContent[])new DomContent[]{this.maybeGenerateTableRowHtml("Object", frame.optString("obj")), this.maybeGenerateTableRowHtml("Function", frame.optString("fn")), this.maybeGenerateStackFrameFileTableRowHtml(frame)});
    }

    private ContainerTag maybeGenerateSuppressionHtml(@CheckForNull String suppression) {
        return (ContainerTag)TagCreator.iff((boolean)StringUtils.isNotBlank((CharSequence)suppression), (Object)TagCreator.div((DomContent[])new DomContent[]{TagCreator.br(), TagCreator.h4((String)"Suppression"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.pre((String)suppression)})})})}));
    }

    private ContainerTag maybeGenerateTableRowHtml(String name, @CheckForNull String value) {
        return (ContainerTag)TagCreator.iff((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.text((String)name), TagCreator.td((DomContent[])new DomContent[]{TagCreator.text((String)value)})})}));
    }

    @CheckForNull
    private ContainerTag maybeGenerateStackFrameFileTableRowHtml(JSONObject frame) throws JSONException {
        String file = frame.optString("file");
        if (StringUtils.isNotBlank((CharSequence)file)) {
            String dir = frame.optString("dir");
            int line = frame.optInt("line", -1);
            StringBuilder fileBuilder = new StringBuilder(256);
            if (StringUtils.isNotBlank((CharSequence)dir)) {
                fileBuilder.append(dir).append('/');
            }
            fileBuilder.append(file);
            if (line != -1) {
                fileBuilder.append(':').append(line);
            }
            return this.maybeGenerateTableRowHtml("File", fileBuilder.toString());
        }
        return null;
    }

    @CheckForNull
    private JSONArray getAuxWhatsArray(Map<String, String> specifics) {
        String auxWhatsJson = specifics.get("auxwhats");
        return StringUtils.isNotBlank((CharSequence)auxWhatsJson) ? new JSONArray(new JSONTokener(auxWhatsJson)) : null;
    }
}

