/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.io.Serializable;

public abstract class DryDescriptor
extends ParserDescriptor {
    public static final String HIGH_OPTION_KEY = "DRY-HIGH-THRESHOLD";
    public static final String NORMAL_OPTION_KEY = "DRY-NORMAL-THRESHOLD";

    DryDescriptor(String id, String name) {
        super(id, name);
    }

    int getHighThreshold(ParserDescriptor.Option ... options) {
        return this.convertThreshold(HIGH_OPTION_KEY, 50, options);
    }

    int getNormalThreshold(ParserDescriptor.Option ... options) {
        return this.convertThreshold(NORMAL_OPTION_KEY, 25, options);
    }

    private int convertThreshold(String key, int defaultValue, ParserDescriptor.Option ... options) {
        for (ParserDescriptor.Option option : options) {
            if (!key.equals(option.getKey())) continue;
            try {
                return Integer.parseInt((String)option.getValue());
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Parser cannot handle option " + String.valueOf(option), exception);
            }
        }
        return defaultValue;
    }

    private String getDuplicateCode(@CheckForNull Serializable properties) {
        if (properties instanceof DuplicationGroup) {
            return TagCreator.pre().with((DomContent)new UnescapedText(DryDescriptor.getCodeFragment((DuplicationGroup)properties))).renderFormatted();
        }
        return "";
    }

    private static String getCodeFragment(DuplicationGroup duplicationGroup) {
        return TagCreator.code((String)duplicationGroup.getCodeFragment()).renderFormatted();
    }

    @Override
    public String getDescription(Issue issue) {
        return this.getDuplicateCode(issue.getAdditionalProperties());
    }
}

