/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.parser.pmd.PmdMessages;
import edu.hm.hafner.analysis.parser.pmd.PmdParser;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.analysis.util.Deferred;

class PmdDescriptor
extends ParserDescriptor {
    private static final String ID = "pmd";
    private static final String NAME = "PMD";
    private final Deferred<PmdMessages> messages = new Deferred<PmdMessages>(PmdMessages::new);

    PmdDescriptor() {
        super(ID, NAME);
    }

    @Override
    public IssueParser createParser(ParserDescriptor.Option ... options) {
        return new PmdParser();
    }

    @Override
    public String getPattern() {
        return "**/pmd.xml";
    }

    @Override
    public String getUrl() {
        return "https://pmd.github.io";
    }

    @Override
    public String getIconUrl() {
        return "https://raw.githubusercontent.com/pmd/pmd/master/docs/images/logo/pmd-logo-300px.png";
    }

    @Override
    public String getDescription(Issue issue) {
        return this.messages.get().getMessage(issue.getCategory(), issue.getType());
    }
}

