/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assumptions;

public abstract class ResourceTest {
    protected boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    protected Path createTempFile() {
        try {
            return Files.createTempFile("test", ".test", new FileAttribute[0]);
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected byte[] readAllBytes(String fileName) {
        try {
            URL resource = this.getTestResourceClass().getResource(fileName);
            this.ensureThatResourceExists(resource, fileName);
            return IOUtils.toByteArray((URL)resource);
        }
        catch (IOException e) {
            throw new AssertionError("Can't read resource " + fileName, e);
        }
    }

    protected byte[] readAllBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new AssertionError("Can't read resource " + path, e);
        }
    }

    @SuppressFBWarnings(value={"UI_INHERITANCE_UNSAFE_GETRESOURCE"})
    private Path getPath(String name) throws URISyntaxException {
        URL resource = this.getTestResourceClass().getResource(name);
        this.ensureThatResourceExists(resource, name);
        return Paths.get(resource.toURI());
    }

    @MustBeClosed
    protected Stream<String> asStream(String fileName) {
        return this.asStream(fileName, StandardCharsets.UTF_8);
    }

    @MustBeClosed
    protected Stream<String> asStream(String fileName, Charset charset) {
        try {
            return Files.lines(this.getPath(fileName), charset);
        }
        catch (IOException | URISyntaxException e) {
            throw new AssertionError("Can't read resource " + fileName, e);
        }
    }

    protected InputStream asInputStream(String fileName) {
        InputStream stream = this.getTestResourceClass().getResourceAsStream(fileName);
        this.ensureThatResourceExists(stream, fileName);
        return stream;
    }

    private void ensureThatResourceExists(Object resource, String fileName) {
        if (resource == null) {
            throw new AssertionError((Object)("Can't find resource " + fileName));
        }
    }

    protected Class<?> getTestResourceClass() {
        return this.getClass();
    }

    protected String toString(String fileName) {
        return this.createString(this.readAllBytes(fileName));
    }

    protected String toString(Path file) {
        return this.createString(this.readAllBytes(file));
    }

    private String createString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected Stream<String> getTextLinesAsStream(String text) {
        return new BufferedReader(new StringReader(text)).lines();
    }

    protected Path getResourceAsFile(String fileName) {
        try {
            URL resource = this.getTestResourceClass().getResource(fileName);
            this.ensureThatResourceExists(resource, fileName);
            return Paths.get(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Can't open file " + fileName, e);
        }
    }

    protected void assumeThatTestIsRunningOnWindows() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isWindows()).as("Test is not running on Windows", new Object[0])).isTrue();
    }

    protected void assumeThatTestIsRunningOnUnix() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isWindows()).as("Test is not running on Unix", new Object[0])).isFalse();
    }
}

