/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.FieldsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public final class ArchitectureRules {
    public static final ArchRule NO_FIELDS_IN_TESTS = ((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areDeclaredInClassesThat().haveSimpleNameEndingWith("Test")).should().beFinal().andShould().haveModifier(JavaModifier.STATIC)).because("use factory methods in favor of instance fields when creating stubs or mocks in tests").allowEmptyShould(true);
    public static final ArchRule NO_EXCEPTIONS_WITH_NO_ARG_CONSTRUCTOR = ((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().haveSimpleNameNotContaining("Benchmark")).should().callConstructorWhere((DescribedPredicate)ArchitectureRules.exceptionHasNoContextAsParameter()).because("exceptions should include failure-capture information in detail messages (Effective Java Item 75)").allowEmptyShould(true);
    public static final ArchRule NO_PUBLIC_TEST_CLASSES = ((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().haveSimpleNameEndingWith("Test")).and().haveSimpleNameNotContaining("_jmh")).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().bePublic().because("test classes are not part of the API and should be hidden in a package");
    public static final ArchRule ONLY_PACKAGE_PRIVATE_TEST_METHODS = ((MethodsShouldConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areAnnotatedWith(Test.class)).or().areAnnotatedWith(ParameterizedTest.class)).and().areDeclaredInClassesThat().haveSimpleNameEndingWith("Test")).should().bePackagePrivate()).because("test methods are not part of the API and should be hidden in a package");
    public static final ArchRule ONLY_PACKAGE_PRIVATE_ARCHITECTURE_TESTS = ((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areAnnotatedWith(ArchTest.class)).should().bePackagePrivate()).because("architecture tests are not part of the API and should be hidden in a package").allowEmptyShould(true);
    public static final ArchRule NO_TEST_API_CALLED = ((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().haveSimpleNameNotEndingWith("Test")).and().haveSimpleNameNotContaining("Benchmark")).should().callCodeUnitWhere(ArchitectureRules.accessIsRestrictedForTests()).because("Production code should never access methods that are marked with @VisibleForTesting").allowEmptyShould(true);
    public static final ArchRule NO_FORBIDDEN_PACKAGE_ACCESSED = (ArchRule)ArchRuleDefinition.noClasses().should().dependOnClassesThat().resideInAnyPackage(new String[]{"org.apache.commons.lang..", "org.joda.time..", "javax.xml.bind..", "net.jcip.annotations..", "junit..", "org.hamcrest..", "com.google.common..", "org.junit"});
    public static final ArchRule NO_FORBIDDEN_ANNOTATION_USED = ((ClassesShouldConjunction)((ClassesShouldConjunction)((ClassesShouldConjunction)((ClassesShouldConjunction)((ClassesShouldConjunction)ArchRuleDefinition.noClasses().should().dependOnClassesThat().haveNameMatching("javax.annotation.Check.*")).orShould().dependOnClassesThat().haveNameMatching("javax.annotation.Nonnull")).orShould().dependOnClassesThat().haveNameMatching("javax.annotation.Nullable")).orShould().dependOnClassesThat().haveNameMatching("javax.annotation.Parameters.*")).orShould().dependOnClassesThat().haveNameMatching("edu.umd.cs.findbugs.annotations.Nullable")).because("JSR 305 annotations are now part of edu.umd.cs.findbugs.annotations package");
    public static final ArchRule NO_FORBIDDEN_CLASSES_CALLED = ArchRuleDefinition.noClasses().should().callCodeUnitWhere(JavaAccess.Predicates.targetOwner((DescribedPredicate)ArchPredicates.has((DescribedPredicate)ArchConditions.fullyQualifiedName((String)"org.junit.jupiter.api.Assertions").or(ArchConditions.fullyQualifiedName((String)"org.junit.Assert"))))).because("only AssertJ should be used for assertions");
    public static final ArchRule READ_RESOLVE_SHOULD_BE_PROTECTED = ((MethodsShouldConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().haveName("readResolve")).and().haveRawReturnType(Object.class)).should().beDeclaredInClassesThat().implement(Serializable.class)).andShould(ArchitectureRules.beProtected()).allowEmptyShould(true);

    private static ExceptionHasNoContext exceptionHasNoContextAsParameter() {
        return new ExceptionHasNoContext(new Class[0]);
    }

    private static DescribedPredicate<? super JavaCall<?>> accessIsRestrictedForTests() {
        return new AccessRestrictedToTests();
    }

    private ArchitectureRules() {
    }

    private static ArchCondition<JavaMethod> beProtected() {
        return new ShouldBeProtectedCondition();
    }

    private static class ExceptionHasNoContext
    extends DescribedPredicate<JavaConstructorCall> {
        private final List<Class<? extends Throwable>> allowedExceptions;

        @SafeVarargs
        ExceptionHasNoContext(Class<? extends Throwable> ... allowedExceptions) {
            super("exception context is missing", new Object[0]);
            this.allowedExceptions = List.of(allowedExceptions);
        }

        public boolean test(JavaConstructorCall javaConstructorCall) {
            AccessTarget.ConstructorCallTarget target = (AccessTarget.ConstructorCallTarget)javaConstructorCall.getTarget();
            if (target.getRawParameterTypes().size() > 0) {
                return false;
            }
            return target.getOwner().isAssignableTo(Throwable.class) && !this.isPermittedException(target.getOwner());
        }

        private boolean isPermittedException(JavaClass owner) {
            return this.allowedExceptions.stream().anyMatch(arg_0 -> ((JavaClass)owner).isAssignableTo(arg_0));
        }
    }

    private static class AccessRestrictedToTests
    extends DescribedPredicate<JavaCall<?>> {
        AccessRestrictedToTests() {
            super("access is restricted to tests", new Object[0]);
        }

        public boolean test(JavaCall<?> input) {
            return this.isVisibleForTesting((CanBeAnnotated)input.getTarget()) && !input.getOriginOwner().equals(input.getTargetOwner()) && !this.isVisibleForTesting((CanBeAnnotated)input.getOrigin());
        }

        private boolean isVisibleForTesting(CanBeAnnotated target) {
            return target.isAnnotatedWith(VisibleForTesting.class);
        }
    }

    private static class ShouldBeProtectedCondition
    extends ArchCondition<JavaMethod> {
        ShouldBeProtectedCondition() {
            super("should be protected", new Object[0]);
        }

        public void check(JavaMethod method, ConditionEvents events) {
            if (method.getModifiers().contains(JavaModifier.PROTECTED)) {
                return;
            }
            if (method.getOwner().getModifiers().contains(JavaModifier.FINAL)) {
                return;
            }
            events.add(SimpleConditionEvent.violated((Object)method, (String)String.format("%s is not protected but the class might be extended in %s", method.getDescription(), method.getSourceCodeLocation())));
        }
    }
}

