/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.vackosar.gitflowincrementalbuild.boundary.GuiceModule;
import com.vackosar.gitflowincrementalbuild.boundary.UnchangedProjectsRemover;
import com.vackosar.gitflowincrementalbuild.control.Property;
import com.vackosar.gitflowincrementalbuild.entity.SkipExecutionException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class MavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    private UnchangedProjectsRemover worker;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            this.mergeCurrentProjectProperties(session);
            if (Boolean.valueOf(Property.enabled.getValue()).booleanValue()) {
                this.logger.info("gitflow-incremental-builder starting...");
                this.worker = (UnchangedProjectsRemover)Guice.createInjector((Module[])new Module[]{new GuiceModule(this.logger, session)}).getInstance(UnchangedProjectsRemover.class);
                this.worker.act();
                this.logger.info("gitflow-incremental-builder exiting...");
            } else {
                this.logger.info("gitflow-incremental-builder is disabled.");
            }
        }
        catch (Exception e) {
            Boolean failOnError = Boolean.valueOf(Property.failOnError.getValue());
            if (!failOnError.booleanValue() || e.getMessage().contains(SkipExecutionException.class.getCanonicalName())) {
                this.logger.info("gitflow-incremental-builder execution skipped: " + e.getMessage());
                this.logger.debug("Full exception:", (Throwable)e);
            }
            throw new MavenExecutionException("Exception during gitflow-incremental-builder execution occurred.", (Throwable)e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        try {
            this.worker.checkSkippedModules();
        }
        catch (Exception e) {
            throw new MavenExecutionException("Exception during gitflow-incremental-builder execution occurred.", (Throwable)e);
        }
    }

    private void mergeCurrentProjectProperties(MavenSession mavenSession) {
        mavenSession.getTopLevelProject().getProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith("gib.")).filter(e -> System.getProperty(e.getKey().toString()) == null).forEach(e -> System.setProperty(e.getKey().toString(), e.getValue().toString()));
    }
}

