/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.google.inject.Singleton;
import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.ChangedProjects;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jgit.api.errors.GitAPIException;

@Singleton
class UnchangedProjectsRemover {
    private static final String MAVEN_TEST_SKIP = "maven.test.skip";
    private static final String MAVEN_TEST_SKIP_EXEC = "skipTests";
    static final String TEST_JAR_DETECTED = "Dependency with test-jar goal detected. Will compile test sources.";
    private static final String GOAL_TEST_COMPILE = "test-compile";
    private static final String GOAL_TEST_JAR = "test-jar";
    @Inject
    private Configuration configuration;
    @Inject
    private Logger logger;
    @Inject
    private ChangedProjects changedProjects;
    @Inject
    private MavenSession mavenSession;

    UnchangedProjectsRemover() {
    }

    void act() throws GitAPIException, IOException {
        this.checkAndUpdateDependencies();
        Set<MavenProject> changed = this.getChangedModules();
        this.printDelimiter();
        this.logProjects(changed, "Changed Artifacts:");
        Set<MavenProject> impacted = this.mavenSession.getAllProjects().stream().filter(changed::contains).flatMap(p -> this.getAllDependents(this.mavenSession.getAllProjects(), (MavenProject)p).stream()).collect(Collectors.toSet());
        if (!this.configuration.buildAll) {
            Set<MavenProject> rebuild = this.getRebuildProjects(impacted);
            if (rebuild.isEmpty()) {
                this.validateCurrentProject();
            } else {
                ArrayList<MavenProject> rebuildList = new ArrayList<MavenProject>();
                for (MavenProject proj : this.mavenSession.getProjects()) {
                    if (!rebuild.contains(proj)) continue;
                    rebuildList.add(proj);
                }
                if (rebuildList.isEmpty()) {
                    this.validateCurrentProject();
                } else {
                    this.mavenSession.setProjects(rebuildList);
                }
            }
        } else {
            this.mavenSession.getProjects().stream().filter(p -> !impacted.contains(p)).forEach(this::ifSkipDependenciesTest);
        }
        if (this.configuration.useEkstazi) {
            boolean forceall;
            boolean bl = forceall = !this.changedProjects.isJavaChangesOnly();
            if (forceall) {
                this.logger.info("EKSTAZI TURNED OFF, NOT ALL JAVA CHANGES");
            }
            for (MavenProject proj : this.mavenSession.getProjects()) {
                Build build = proj.getBuild();
                this.addEkstaziPlugin(build, forceall);
                proj.setBuild(build);
            }
        }
    }

    private Set<MavenProject> getChangedModules() throws GitAPIException, IOException {
        Set<MavenProject> result = this.changedProjects.get();
        if (this.configuration.skippedModulesFile.equals("")) {
            return result;
        }
        HashSet<String> skippedModules = new HashSet<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.configuration.skippedModulesFile));
            while ((line = br.readLine()) != null) {
                skippedModules.add(line);
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            this.logger.info("The file set for skippedModulesFile is not found.");
        }
        catch (IOException ex) {
            this.logger.info("The file set for skippedModulesFile is empty.");
        }
        for (MavenProject proj : this.mavenSession.getAllProjects()) {
            if (!skippedModules.contains(proj.toString())) continue;
            result.add(proj);
        }
        return result;
    }

    void checkSkippedModules() {
        if (this.configuration.skippedModulesFile.equals("")) {
            return;
        }
        StringBuilder skippedModulesSB = new StringBuilder();
        MavenExecutionResult result = this.mavenSession.getResult();
        for (MavenProject project : this.mavenSession.getProjects()) {
            if (result.getBuildSummary(project) != null) continue;
            skippedModulesSB.append(project.toString());
            skippedModulesSB.append("\n");
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.configuration.skippedModulesFile));
            bw.write(skippedModulesSB.toString());
            bw.newLine();
            bw.close();
        }
        catch (IOException ex) {
            this.logger.info("Exception when writing skipped modules to the file.");
        }
    }

    private void validateCurrentProject() {
        this.logger.info("No changed artifacts to build. Executing validate goal on current project only.");
        this.mavenSession.setProjects(Collections.singletonList(this.mavenSession.getCurrentProject()));
        this.mavenSession.getGoals().clear();
        this.mavenSession.getGoals().add("validate");
    }

    private void checkAndUpdateDependencies() {
        if (this.configuration.classpathFile.equals("")) {
            return;
        }
        StringBuilder oldClasspathSB = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.configuration.classpathFile));
            while ((line = br.readLine()) != null) {
                oldClasspathSB.append(line);
                oldClasspathSB.append("\n");
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            this.logger.info("The file set for classpathFile is not found, will make new file in its place.");
        }
        catch (IOException ex) {
            this.logger.info("The file set for classpathFile is empty, will overwrite it.");
        }
        String oldClasspath = oldClasspathSB.toString();
        HashMap proj2Deps = new HashMap();
        HashSet<String> internalDeps = new HashSet<String>();
        for (MavenProject proj : this.mavenSession.getAllProjects()) {
            String projId = proj.getGroupId() + ":" + proj.getArtifactId();
            internalDeps.add((String)projId + ":" + proj.getVersion());
            HashSet dependencies = new HashSet();
            dependencies.addAll(proj.getDependencies());
            proj2Deps.put(projId, dependencies);
        }
        StringBuilder newClasspathSB = new StringBuilder();
        ArrayList projIds = new ArrayList(proj2Deps.keySet());
        Collections.sort(projIds);
        for (String projId : projIds) {
            newClasspathSB.append(projId);
            newClasspathSB.append("=");
            ArrayList<String> depNames = new ArrayList<String>();
            for (Dependency dependency : (Set)proj2Deps.get(projId)) {
                String depName = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
                if (!internalDeps.contains(depName)) {
                    depNames.add(depName);
                    continue;
                }
                depNames.add(dependency.getGroupId() + ":" + dependency.getArtifactId());
            }
            Collections.sort(depNames);
            for (String string : depNames) {
                newClasspathSB.append(string);
                newClasspathSB.append(",");
            }
            newClasspathSB.append("\n");
        }
        String newClasspath = newClasspathSB.toString();
        if (newClasspath.trim().equals(oldClasspath.trim())) {
            this.configuration.excludePathRegex = this.configuration.excludePathRegex.or(Pattern.compile("(pom.xml$)").asPredicate());
            this.logger.info("EXCLUDING pom.xml, DEPENDENCIES DID NOT CHANGE");
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.configuration.classpathFile));
            bw.write(newClasspath);
            bw.newLine();
            bw.close();
        }
        catch (IOException ex) {
            this.logger.info("Exception when writing classpath to the file.");
        }
    }

    private void addEkstaziPlugin(Build build, boolean forceall) {
        Plugin ekstazi = new Plugin();
        ekstazi.setGroupId("org.ekstazi");
        ekstazi.setArtifactId("ekstazi-maven-plugin");
        ekstazi.setVersion("5.2.0");
        PluginExecution execution = new PluginExecution();
        execution.setId("ekstazi");
        execution.addGoal("select");
        if (forceall) {
            Xpp3Dom configurationNode = new Xpp3Dom("configuration");
            Xpp3Dom forceallNode = new Xpp3Dom("forceall");
            forceallNode.setValue("true");
            configurationNode.addChild(forceallNode);
            execution.setConfiguration((Object)configurationNode);
        }
        ekstazi.addExecution(execution);
        build.addPlugin(ekstazi);
    }

    private Set<MavenProject> getRebuildProjects(Set<MavenProject> changedProjects) {
        if (this.configuration.makeUpstream) {
            return Stream.concat(changedProjects.stream(), this.collectDependencies(changedProjects)).collect(Collectors.toSet());
        }
        return changedProjects;
    }

    private Stream<MavenProject> collectDependencies(Set<MavenProject> changedProjects) {
        return changedProjects.stream().flatMap(this::ifMakeUpstreamGetDependencies).filter(p -> !changedProjects.contains(p)).map(this::ifSkipDependenciesTest);
    }

    private MavenProject ifSkipDependenciesTest(MavenProject mavenProject) {
        if (this.configuration.skipTestsForNotImpactedModules) {
            if (this.projectDeclaresTestJarGoal(mavenProject)) {
                this.logger.debug(mavenProject.getArtifactId() + ": " + TEST_JAR_DETECTED);
                mavenProject.getProperties().setProperty(MAVEN_TEST_SKIP_EXEC, Boolean.TRUE.toString());
            } else {
                mavenProject.getProperties().setProperty(MAVEN_TEST_SKIP, Boolean.TRUE.toString());
            }
        }
        return mavenProject;
    }

    private boolean projectDeclaresTestJarGoal(MavenProject mavenProject) {
        return mavenProject.getBuildPlugins().stream().flatMap(p -> p.getExecutions().stream()).flatMap(e -> e.getGoals().stream()).anyMatch(GOAL_TEST_JAR::equals);
    }

    private void logProjects(Set<MavenProject> projects, String title) {
        this.logger.info(title);
        this.logger.info("");
        projects.stream().map(MavenProject::getArtifactId).forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
        this.logger.info("");
    }

    private void printDelimiter() {
        this.logger.info("------------------------------------------------------------------------");
    }

    private Set<MavenProject> getAllDependents(List<MavenProject> projects, MavenProject project) {
        HashSet<MavenProject> result = new HashSet<MavenProject>();
        result.add(project);
        for (MavenProject possibleDependent : projects) {
            if (this.isDependentOf(possibleDependent, project)) {
                result.addAll(this.getAllDependents(projects, possibleDependent));
            }
            if (!project.equals((Object)possibleDependent.getParent())) continue;
            result.addAll(this.getAllDependents(projects, possibleDependent));
        }
        return result;
    }

    private Stream<MavenProject> ifMakeUpstreamGetDependencies(MavenProject mavenProject) {
        return this.getAllDependencies(this.mavenSession.getProjects(), mavenProject).stream();
    }

    private Set<MavenProject> getAllDependencies(List<MavenProject> projects, MavenProject project) {
        Set<MavenProject> dependencies = project.getDependencies().stream().map(d -> this.convert(projects, (Dependency)d)).filter(Optional::isPresent).map(Optional::get).flatMap(p -> this.getAllDependencies(projects, (MavenProject)p).stream()).collect(Collectors.toSet());
        dependencies.add(project);
        return dependencies;
    }

    private boolean equals(MavenProject project, Dependency dependency) {
        return dependency.getArtifactId().equals(project.getArtifactId()) && dependency.getGroupId().equals(project.getGroupId()) && dependency.getVersion().equals(project.getVersion());
    }

    private Optional<MavenProject> convert(List<MavenProject> projects, Dependency dependency) {
        return projects.stream().filter(p -> this.equals((MavenProject)p, dependency)).findFirst();
    }

    private boolean isDependentOf(MavenProject possibleDependent, MavenProject project) {
        return possibleDependent.getDependencies().stream().anyMatch(d -> this.equals(project, (Dependency)d));
    }
}

