/*
The MIT License (MIT)
Copyright (c) 2015 Alex Gyori
Copyright (c) 2022 Kaiyao Ke
Copyright (c) 2015 Owolabi Legunsen
Copyright (c) 2015 Darko Marinov
Copyright (c) 2015 August Shi


Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package edu.illinois.nondex.common;

import java.io.PrintStream;

public class Logger {

    private static final Logger INSTANCE = new Logger();
    private PrintStream out = System.out;
    private Level level = Level.CONFIG;

    public void setLoggingLevel(Level level) {
        this.level = level;
    }

    public Level getLoggingLevel() {
        return this.level;
    }

    public static Logger getGlobal() {
        return Logger.INSTANCE;
    }

    public void log(Level lev, String msg, Throwable thr) {
        if (lev.intValue() < this.level.intValue()) {
            return;
        }
        this.out.println(lev.toString() + ": " + msg);
        this.out.println(thr);
    }

    public void log(Level lev, String msg) {
        if (lev.intValue() < this.level.intValue()) {
            return;
        }
        this.out.println(lev.toString() + ": " + msg);
    }
}
