/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Utils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class CleanSurefireExecution {
    protected Configuration configuration;
    protected final String executionId;
    protected Plugin surefire;
    protected MavenProject mavenProject;
    protected MavenSession mavenSession;
    protected BuildPluginManager pluginManager;
    protected String originalArgLine;

    protected CleanSurefireExecution(Plugin surefire, String originalArgLine, String executionId, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, String nondexDir) {
        this.executionId = executionId;
        this.surefire = surefire;
        this.originalArgLine = originalArgLine;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.configuration = new Configuration(executionId, nondexDir);
    }

    public CleanSurefireExecution(Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, String nondexDir) {
        this(surefire, originalArgLine, "clean_" + Utils.getFreshExecutionId(), mavenProject, mavenSession, pluginManager, nondexDir);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void run() throws MojoExecutionException {
        this.setupArgline();
        try {
            Logger.getGlobal().log(Level.CONFIG, this.configuration.toString());
            MojoExecutor.executeMojo((Plugin)this.surefire, (String)MojoExecutor.goal((String)"test"), (Xpp3Dom)this.setReportOutputDirectory((Xpp3Dom)this.surefire.getConfiguration()), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException mojoException) {
            Logger.getGlobal().log(Level.INFO, "Surefire failed when running tests for " + this.configuration.executionId);
            SurefireReportParser parser = new SurefireReportParser(Arrays.asList(this.configuration.getExecutionDir().toFile()), Locale.getDefault());
            try {
                LinkedHashSet<String> failingTests = new LinkedHashSet<String>();
                for (ReportTestSuite report : parser.parseXMLReportFiles()) {
                    for (ReportTestCase testCase : report.getTestCases()) {
                        if (!testCase.hasFailure() || "skipped".equals(testCase.getFailureType())) continue;
                        failingTests.add(testCase.getFullClassName() + '#' + testCase.getName());
                    }
                }
                this.configuration.setFailures(failingTests);
            }
            catch (MavenReportException ex) {
                throw new MojoExecutionException("Failed to parse mvn reports!");
            }
            throw mojoException;
        }
    }

    protected void setupArgline() {
        Logger.getGlobal().log(Level.FINE, "Running clean surefire.");
        this.mavenProject.getProperties().setProperty("argLine", this.originalArgLine + " " + this.configuration.toArgLine());
    }

    private Xpp3Dom setReportOutputDirectory(Xpp3Dom configuration) {
        Xpp3Dom configNode = configuration;
        if (configNode == null) {
            configNode = new Xpp3Dom("configuration");
        }
        configNode = this.addAttributeToConfig(configNode, "reportsDirectory", this.configuration.getExecutionDir().toString());
        configNode = this.addAttributeToConfig(configNode, "disableXmlReport", "false");
        return configNode;
    }

    private Xpp3Dom addAttributeToConfig(Xpp3Dom configNode, String nodeName, String value) {
        for (Xpp3Dom config : configNode.getChildren()) {
            if (!nodeName.equals(config.getName())) continue;
            config.setValue(value);
            return configNode;
        }
        configNode.addChild(this.makeNode(nodeName, value));
        return configNode;
    }

    private Xpp3Dom makeNode(String nodeName, String value) {
        Xpp3Dom node = new Xpp3Dom(nodeName);
        node.setValue(value);
        return node;
    }
}

