/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.plugin.NonDexSurefireExecution;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class DebugTask {
    private String test;
    private Plugin surefire;
    private String originalArgLine;
    private MavenProject mavenProject;
    private MavenSession mavenSession;
    private BuildPluginManager pluginManager;
    private List<Configuration> failingConfigurations;

    public DebugTask(String test, Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, List<Configuration> failingConfigurations) {
        this.test = test;
        this.surefire = surefire;
        this.originalArgLine = originalArgLine;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.failingConfigurations = failingConfigurations;
    }

    public String debug() throws MojoExecutionException {
        assert (!this.failingConfigurations.isEmpty());
        String defaultTest = this.test;
        String testClass = this.test.substring(0, this.test.indexOf(35));
        for (String test : new String[]{defaultTest, testClass, ""}) {
            this.test = test.contains("[") ? test.substring(0, test.indexOf(91)) : test;
            String result = this.tryDebugSeeds();
            if (result == null) continue;
            return result;
        }
        return "cannot reproduce. may be flaky due to other causes";
    }

    private String tryDebugSeeds() {
        Configuration failingOne = this.debugWithConfigurations(this.failingConfigurations);
        if (failingOne != null) {
            return failingOne.toArgLine() + "\nDEBUG RESULTS FOR " + failingOne.testName + " AT: " + failingOne.getDebugPath();
        }
        List<Configuration> retryWOtherSeeds = this.createNewSeedsToRetry();
        failingOne = this.debugWithConfigurations(retryWOtherSeeds);
        if (failingOne != null) {
            return failingOne.toArgLine() + "\nDEBUG RESULTS FOR " + failingOne.testName + " AT: " + failingOne.getDebugPath();
        }
        return null;
    }

    private List<Configuration> createNewSeedsToRetry() {
        Configuration someFailingConfig = this.failingConfigurations.iterator().next();
        int newSeed = someFailingConfig.seed * 41444;
        LinkedList<Configuration> retryWOtherSeeds = new LinkedList<Configuration>();
        for (int i = 0; i < 10; ++i) {
            Configuration newConfig = new Configuration(someFailingConfig.mode, Utils.computeIthSeed((int)i, (boolean)false, (int)newSeed), someFailingConfig.filter, someFailingConfig.start, someFailingConfig.end, someFailingConfig.nondexDir, someFailingConfig.nondexJarDir, someFailingConfig.testName, someFailingConfig.executionId);
            retryWOtherSeeds.add(newConfig);
        }
        return retryWOtherSeeds;
    }

    private Configuration debugWithConfigurations(List<Configuration> failingConfigurations) {
        Configuration debConfig = null;
        for (Configuration config : failingConfigurations) {
            Configuration dryConfig = this.failsOnDry(config);
            if (dryConfig == null) continue;
            Configuration failingConfig = this.startDebugBinary(dryConfig);
            if (failingConfig != null && failingConfig.numChoices() == 0L) {
                return failingConfig;
            }
            if (debConfig != null && !failingConfig.hasFewerChoicePoints(debConfig)) continue;
            debConfig = failingConfig;
        }
        return debConfig;
    }

    private Configuration failsOnDry(Configuration config) {
        return this.failsWithConfig(config, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public Configuration startDebugBinary(Configuration config) {
        long start = 0L;
        long end = config.getInvocationCount();
        Configuration failingConfiguration = null;
        while (start < end) {
            Logger.getGlobal().log(Level.INFO, "Debugging binary for " + this.test + " " + start + " : " + end);
            long midPoint = (start + end) / 2L;
            failingConfiguration = this.failsWithConfig(config, start, midPoint);
            if (failingConfiguration != null) {
                end = midPoint;
                continue;
            }
            failingConfiguration = this.failsWithConfig(config, midPoint + 1L, end);
            if (failingConfiguration != null) {
                start = midPoint + 1L;
                continue;
            }
            Logger.getGlobal().log(Level.FINE, "Binary splitting did not work. Going to linear");
            failingConfiguration = this.startDebugLinear(config, start, end);
            break;
        }
        if (failingConfiguration != null) {
            return this.reportDebugInfo(failingConfiguration);
        }
        return failingConfiguration;
    }

    private Configuration reportDebugInfo(Configuration failingConfiguration) {
        return this.failsWithConfig(failingConfiguration, failingConfiguration.start, failingConfiguration.end, true);
    }

    public Configuration startDebugLinear(Configuration config, long start, long end) {
        Configuration failingConfiguration = null;
        long localEnd = end;
        long localStart = start;
        if (localEnd - localStart > 50L) {
            return null;
        }
        while (localStart < localEnd) {
            Logger.getGlobal().log(Level.INFO, "Debugging linear for " + this.test + " " + localStart + " : " + localEnd);
            failingConfiguration = this.failsWithConfig(config, localStart, localEnd - 1L);
            if (failingConfiguration != null) {
                --localEnd;
                continue;
            }
            failingConfiguration = this.failsWithConfig(config, localStart + 1L, localEnd);
            if (failingConfiguration != null) {
                ++localStart;
                continue;
            }
            Logger.getGlobal().log(Level.FINE, "Refining did not work. Does not fail with linear.");
            break;
        }
        return failingConfiguration;
    }

    private Configuration failsWithConfig(Configuration config, long start, long end) {
        return this.failsWithConfig(config, start, end, false);
    }

    private Configuration failsWithConfig(Configuration config, long start, long end, boolean print) {
        NonDexSurefireExecution execution = new NonDexSurefireExecution(config, start, end, print, this.test, this.surefire, this.originalArgLine, this.mavenProject, this.mavenSession, this.pluginManager);
        try {
            execution.run();
        }
        catch (Throwable thr) {
            return execution.getConfiguration();
        }
        return null;
    }
}

