/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Mode;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.plugin.CleanSurefireExecution;
import java.io.File;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class NonDexSurefireExecution
extends CleanSurefireExecution {
    private NonDexSurefireExecution(Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, String nondexDir) {
        super(surefire, originalArgLine, Utils.getFreshExecutionId(), mavenProject, mavenSession, pluginManager, nondexDir);
    }

    public NonDexSurefireExecution(Mode mode, int seed, Pattern filter, long start, long end, String nondexDir, String nondexJarDir, Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        this(surefire, originalArgLine, mavenProject, mavenSession, pluginManager, nondexDir);
        this.configuration = new Configuration(mode, seed, filter, start, end, nondexDir, nondexJarDir, null, this.executionId);
    }

    public NonDexSurefireExecution(Configuration config, long start, long end, boolean print, String test, Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        this(surefire, originalArgLine, mavenProject, mavenSession, pluginManager, config.nondexDir);
        this.configuration = new Configuration(config.mode, config.seed, config.filter, start, end, config.nondexDir, config.nondexJarDir, test, this.executionId, print);
    }

    @Override
    protected void setupArgline() {
        String localRepo = this.mavenSession.getSettings().getLocalRepository();
        String pathToNondex = this.getPathToNondexJar(localRepo);
        Xpp3Dom configElement = (Xpp3Dom)this.surefire.getConfiguration();
        if (configElement != null) {
            configElement.getChild("test").setValue(this.configuration.testName);
        }
        Logger.getGlobal().log(Level.FINE, "Running surefire with: " + this.configuration.toArgLine());
        this.mavenProject.getProperties().setProperty("argLine", "-Xbootclasspath/p:" + pathToNondex + " " + this.originalArgLine + " " + this.configuration.toArgLine());
    }

    private String getPathToNondexJar(String localRepo) {
        String result = Paths.get(this.configuration.nondexJarDir, "nondex-instr.jar") + File.pathSeparator + Paths.get(localRepo, "edu", "illinois", "nondex-common", "1.1.1", "nondex-common-1.1.1.jar");
        Logger.getGlobal().log(Level.FINE, "The nondex path is: " + result);
        return "\"" + result + "\"";
    }
}

