/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Utils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class CleanSurefireExecution {
    protected Configuration configuration;
    protected final String executionId;
    protected Plugin surefire;
    protected MavenProject mavenProject;
    protected MavenSession mavenSession;
    protected BuildPluginManager pluginManager;
    protected String originalArgLine;

    protected CleanSurefireExecution(Plugin surefire, String originalArgLine, String executionId, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, String nondexDir) {
        this.executionId = executionId;
        this.surefire = surefire;
        this.originalArgLine = CleanSurefireExecution.sanitizeAndRemoveEnvironmentVars(originalArgLine);
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.configuration = new Configuration(executionId, nondexDir);
    }

    public CleanSurefireExecution(Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, String nondexDir) {
        this(surefire, originalArgLine, "clean_" + Utils.getFreshExecutionId(), mavenProject, mavenSession, pluginManager, nondexDir);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws MojoExecutionException {
        Xpp3Dom origNode = null;
        if (this.surefire.getConfiguration() != null) {
            origNode = new Xpp3Dom((Xpp3Dom)this.surefire.getConfiguration());
        }
        try {
            Xpp3Dom domNode = this.applyNonDexConfig((Xpp3Dom)this.surefire.getConfiguration());
            this.setupArgline(domNode);
            Logger.getGlobal().log(Level.FINE, "Config node passed: " + domNode.toString());
            Logger.getGlobal().log(Level.FINE, this.mavenProject + "\n" + this.mavenSession + "\n" + this.pluginManager);
            Logger.getGlobal().log(Level.CONFIG, this.configuration.toString());
            Logger.getGlobal().log(Level.FINE, "Surefire config: " + this.surefire + "  " + MojoExecutor.goal((String)"test") + " " + domNode + " " + MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            MojoExecutor.executeMojo((Plugin)this.surefire, (String)MojoExecutor.goal((String)"test"), (Xpp3Dom)domNode, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException mojoException) {
            try {
                Logger.getGlobal().log(Level.INFO, "Surefire failed when running tests for " + this.configuration.executionId);
                SurefireReportParser parser = new SurefireReportParser(Arrays.asList(this.configuration.getExecutionDir().toFile()), Locale.getDefault());
                try {
                    LinkedHashSet<String> failingTests = new LinkedHashSet<String>();
                    Iterator iterator = parser.parseXMLReportFiles().iterator();
                    block7: while (true) {
                        if (!iterator.hasNext()) {
                            this.configuration.setFailures(failingTests);
                            throw mojoException;
                        }
                        ReportTestSuite report = (ReportTestSuite)iterator.next();
                        Iterator iterator2 = report.getTestCases().iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block7;
                            ReportTestCase testCase = (ReportTestCase)iterator2.next();
                            if (!testCase.hasFailure() || "skipped".equals(testCase.getFailureType())) continue;
                            failingTests.add(testCase.getFullClassName() + '#' + testCase.getName());
                        }
                        break;
                    }
                }
                catch (MavenReportException ex) {
                    throw new MojoExecutionException("Failed to parse mvn reports!");
                }
                catch (Throwable tr) {
                    Logger.getGlobal().log(Level.SEVERE, "Some exception that is highly unexpected: ", tr);
                    throw tr;
                }
            }
            catch (Throwable throwable) {
                this.surefire.setConfiguration(origNode);
                throw throwable;
            }
        }
        this.surefire.setConfiguration((Object)origNode);
    }

    protected void setupArgline(Xpp3Dom configNode) {
        String argLineToSet = this.configuration.toArgLine();
        boolean added = false;
        for (Xpp3Dom config : configNode.getChildren()) {
            if (!"argLine".equals(config.getName())) continue;
            Logger.getGlobal().log(Level.INFO, "Adding NonDex argLine to existing argLine specified by the project");
            String current = CleanSurefireExecution.sanitizeAndRemoveEnvironmentVars(config.getValue());
            config.setValue(argLineToSet + " " + current);
            added = true;
            break;
        }
        if (!added) {
            Logger.getGlobal().log(Level.INFO, "Creating new argline for Surefire");
            configNode.addChild(this.makeNode("argLine", argLineToSet));
        }
        this.mavenProject.getProperties().setProperty("argLine", this.originalArgLine + " " + argLineToSet);
    }

    protected Xpp3Dom applyNonDexConfig(Xpp3Dom configuration) {
        Xpp3Dom configNode = configuration;
        if (configNode == null) {
            configNode = new Xpp3Dom("configuration");
        }
        return this.setReportOutputDirectory(configNode);
    }

    protected Xpp3Dom setReportOutputDirectory(Xpp3Dom configNode) {
        configNode = this.addAttributeToConfig(configNode, "reportsDirectory", this.configuration.getExecutionDir().toString());
        configNode = this.addAttributeToConfig(configNode, "disableXmlReport", "false");
        return configNode;
    }

    private Xpp3Dom addAttributeToConfig(Xpp3Dom configNode, String nodeName, String value) {
        for (Xpp3Dom config : configNode.getChildren()) {
            if (!nodeName.equals(config.getName())) continue;
            config.setValue(value);
            return configNode;
        }
        configNode.addChild(this.makeNode(nodeName, value));
        return configNode;
    }

    protected Xpp3Dom makeNode(String nodeName, String value) {
        Xpp3Dom node = new Xpp3Dom(nodeName);
        node.setValue(value);
        return node;
    }

    protected static String sanitizeAndRemoveEnvironmentVars(String toSanitize) {
        String pattern = "\\$\\{([A-Za-z0-9\\.\\-]+)\\}";
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(toSanitize);
        while (matcher.find()) {
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            toSanitize = subexpr.matcher(toSanitize).replaceAll("");
        }
        return toSanitize.trim();
    }
}

