/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean", requiresDirectInvocation=true)
public class CleanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}")
    protected File baseDir;

    public void execute() throws MojoExecutionException {
        Path nondexArtifactsPath = Paths.get(this.baseDir.getAbsolutePath(), ".nondex");
        Path nondexJarPath = Paths.get(this.baseDir.getAbsolutePath(), ".nondex", "nondex-instr.jar");
        File artifactsDir = nondexArtifactsPath.toFile();
        File nondexJar = nondexJarPath.toFile();
        if (nondexJar.exists()) {
            this.delete(nondexJar);
        }
        if (artifactsDir.exists()) {
            this.delete(artifactsDir);
        }
    }

    public void delete(File file) {
        if (file.isDirectory()) {
            for (File childFile : file.listFiles()) {
                this.delete(childFile);
            }
        }
        file.delete();
    }
}

