/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Level;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.plugin.AbstractNonDexMojo;
import edu.illinois.nondex.plugin.DebugTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="debug", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class DebugMojo
extends AbstractNonDexMojo {
    private List<String> executions = new LinkedList<String>();
    private ListMultimap<String, Configuration> testsFailing = LinkedListMultimap.create();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.parseExecutions();
        this.parseTests();
        HashMap<String, String> testToRepro = new HashMap<String, String>();
        for (String string : this.testsFailing.keySet()) {
            this.runSingleSurefireTest(string);
            DebugTask debugging = new DebugTask(string, this.surefire, this.originalArgLine, this.mavenProject, this.mavenSession, this.pluginManager, this.testsFailing.get((Object)string));
            String repro = debugging.debug();
            testToRepro.put(string, repro);
        }
        this.getLog().warn((CharSequence)"*********");
        for (Map.Entry entry : testToRepro.entrySet()) {
            this.getLog().warn((CharSequence)("REPRO for " + (String)entry.getKey() + ":" + String.format("%n", new Object[0]) + "mvn nondex:nondex " + (String)entry.getValue()));
        }
    }

    private void runSingleSurefireTest(String test) {
        Xpp3Dom testElem;
        Xpp3Dom configElement = (Xpp3Dom)this.surefire.getConfiguration();
        if (configElement == null) {
            configElement = new Xpp3Dom("configuration");
        }
        if ((testElem = configElement.getChild("test")) == null) {
            testElem = new Xpp3Dom("test");
            testElem.setValue(test);
            configElement.addChild(testElem);
        } else {
            testElem.setValue(test);
        }
        Logger.getGlobal().log(Level.SEVERE, configElement.toString());
        this.surefire.setConfiguration((Object)configElement);
    }

    private void parseTests() {
        for (String execution : this.executions) {
            Properties props = Utils.openPropertiesFrom((Path)Paths.get(this.baseDir.getAbsolutePath(), ".nondex", execution, "config"));
            Configuration config = Configuration.parseArgs((Properties)props);
            for (String test : config.getFailedTests()) {
                this.testsFailing.put((Object)test, (Object)config);
            }
        }
    }

    private void parseExecutions() {
        File run = Paths.get(this.baseDir.getAbsolutePath(), ".nondex", this.runId).toFile();
        try (BufferedReader br = new BufferedReader(new FileReader(run));){
            String line;
            while ((line = br.readLine()) != null) {
                this.executions.add(line.trim());
            }
        }
        catch (IOException ex) {
            Logger.getGlobal().log(Level.SEVERE, "Could not open run file to parse executions", (Throwable)ex);
        }
    }
}

