/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Level;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.plugin.AbstractNonDexMojo;
import edu.illinois.nondex.plugin.CleanSurefireExecution;
import edu.illinois.nondex.plugin.NonDexSurefireExecution;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="nondex", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class NonDexMojo
extends AbstractNonDexMojo {
    private List<NonDexSurefireExecution> executions = new LinkedList<NonDexSurefireExecution>();
    private ArrayList<CleanSurefireExecution> executionsWithoutShuffling = new ArrayList();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Logger.getGlobal().log(Level.INFO, "The original argline is: " + this.originalArgLine);
        MojoExecutionException allExceptions = null;
        for (int j = 0; j < this.numRunsWithoutShuffling; ++j) {
            CleanSurefireExecution cleanExec = new CleanSurefireExecution(this.surefire, this.originalArgLine, this.mavenProject, this.mavenSession, this.pluginManager, Paths.get(this.baseDir.getAbsolutePath(), ".nondex").toString());
            this.executeSurefireExecution(allExceptions, cleanExec);
            this.executionsWithoutShuffling.add(cleanExec);
        }
        for (int i = 0; i < this.numRuns; ++i) {
            NonDexSurefireExecution execution = new NonDexSurefireExecution(this.mode, this.computeIthSeed(i), Pattern.compile(this.filter), this.start, this.end, Paths.get(this.baseDir.getAbsolutePath(), ".nondex").toString(), Paths.get(this.baseDir.getAbsolutePath(), ".nondex").toString(), this.surefire, this.originalArgLine, this.mavenProject, this.mavenSession, this.pluginManager);
            this.executions.add(execution);
            allExceptions = this.executeSurefireExecution(allExceptions, execution);
            this.writeCurrentRunInfo(execution);
        }
        for (CleanSurefireExecution cleanExec : this.executionsWithoutShuffling) {
            this.writeCurrentRunInfo(cleanExec);
            this.postProcessExecutions(cleanExec);
        }
        Configuration config = this.executions.get(0).getConfiguration();
        this.printSummary(config);
        try {
            Files.copy(config.getRunFilePath(), config.getLatestRunFilePath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            Logger.getGlobal().log(Level.SEVERE, "Could not copy current run info to latest", (Throwable)ex);
        }
        this.getLog().info((CharSequence)("[NonDex] The id of this run is: " + this.executions.get((int)0).getConfiguration().executionId));
        if (allExceptions != null) {
            throw allExceptions;
        }
    }

    private void postProcessExecutions(CleanSurefireExecution cleanExec) {
        Collection failedInClean = cleanExec.getConfiguration().getFailedTests();
        for (NonDexSurefireExecution exec : this.executions) {
            exec.getConfiguration().filterTests(failedInClean);
        }
    }

    private MojoExecutionException executeSurefireExecution(MojoExecutionException allExceptions, CleanSurefireExecution execution) {
        try {
            execution.run();
        }
        catch (MojoExecutionException ex) {
            return (MojoExecutionException)Utils.linkException((Throwable)ex, (Throwable)allExceptions);
        }
        return allExceptions;
    }

    private int computeIthSeed(int ithSeed) {
        return Utils.computeIthSeed((int)ithSeed, (boolean)this.rerun, (int)this.seed);
    }

    private void printSummary(Configuration config) {
        LinkedHashSet<String> allFailures = new LinkedHashSet<String>();
        LinkedHashMap<String, Integer> countsOfFailingTestsWithoutShuffling = new LinkedHashMap<String, Integer>();
        boolean failsWithoutShuffling = false;
        this.getLog().info((CharSequence)"NonDex SUMMARY:");
        for (CleanSurefireExecution cleanSurefireExecution : this.executions) {
            this.printExecutionResults(allFailures, cleanSurefireExecution);
        }
        for (int i = 0; i < this.executionsWithoutShuffling.size(); ++i) {
            CleanSurefireExecution cleanSurefireExecution = this.executionsWithoutShuffling.get(i);
            Collection failedTests = cleanSurefireExecution.getConfiguration().getFailedTests();
            if (failedTests.isEmpty()) continue;
            failsWithoutShuffling = true;
            if (this.numRunsWithoutShuffling == 1) {
                this.getLog().info((CharSequence)"The following tests failed in the clean run:");
            } else {
                this.getLog().info((CharSequence)("In run #" + String.valueOf(i + 1) + " without NonDex shuffling, the following tests failed:"));
            }
            for (String test : failedTests) {
                this.getLog().warn((CharSequence)test);
                int count = countsOfFailingTestsWithoutShuffling.containsKey(test) ? (Integer)countsOfFailingTestsWithoutShuffling.get(test) : 0;
                countsOfFailingTestsWithoutShuffling.put(test, count + 1);
            }
        }
        if (failsWithoutShuffling && this.numRunsWithoutShuffling > 1) {
            this.getLog().info((CharSequence)"------------------");
            this.getLog().info((CharSequence)"The following tests are failing in clean runs without NonDex shuffling");
            for (Map.Entry entry : countsOfFailingTestsWithoutShuffling.entrySet()) {
                this.getLog().info((CharSequence)("Test: " + (String)entry.getKey()));
                this.getLog().info((CharSequence)("Fails in " + String.valueOf(entry.getValue()) + " out of " + String.valueOf(this.numRunsWithoutShuffling) + " clean runs."));
            }
        } else if (!failsWithoutShuffling) {
            this.getLog().info((CharSequence)"All tests pass without NonDex shuffling");
        }
        this.getLog().info((CharSequence)"####################");
        this.getLog().info((CharSequence)"Across all seeds:");
        for (String string : allFailures) {
            this.getLog().info((CharSequence)string);
        }
        this.generateHtml(allFailures, config);
    }

    private void generateHtml(Set<String> allFailures, Configuration config) {
        String head = "<!DOCTYPE html><html><head><title>Test Results</title><style>table { border-collapse: collapse; width: 100%; }th { height: 50%; }th, td { padding: 10px; text-align: left; }tr:nth-child(even) {background-color:#f2f2f2;}.x { color: red; font-size: 150%;}.\u2713 { color: green; font-size: 150%;}</style></head>";
        String html = head + "<body><table>";
        html = html + "<thead><tr>";
        html = html + "<th>Test Name</th>";
        for (int iter = 0; iter < this.executions.size(); ++iter) {
            html = html + "<th>";
            html = html + "" + this.executions.get((int)iter).getConfiguration().seed;
            html = html + "</th>";
        }
        html = html + "</tr></thead>";
        html = html + "<tbody>";
        for (String failure : allFailures) {
            html = html + "<tr><td>" + failure + "</td>";
            for (CleanSurefireExecution cleanSurefireExecution : this.executions) {
                boolean testDidFail = false;
                for (String test : cleanSurefireExecution.getConfiguration().getFailedTests()) {
                    if (!test.equals(failure)) continue;
                    testDidFail = true;
                }
                if (testDidFail) {
                    html = html + "<td class=\"x\">&#10006;</td>";
                    continue;
                }
                html = html + "<td class=\"\u2713\">&#10004;</td>";
            }
            html = html + "</tr>";
        }
        html = html + "</tbody></table></body></html>";
        File nondexDir = config.getNondexDir().toFile();
        File htmlFile = new File(nondexDir, "test_results.html");
        try {
            PrintWriter htmlPrinter = new PrintWriter(htmlFile);
            htmlPrinter.print(html);
            htmlPrinter.close();
        }
        catch (FileNotFoundException ex) {
            this.getLog().info((CharSequence)"File Missing.  But that shouldn't happen...");
        }
        this.getLog().info((CharSequence)"Test results can be found at: ");
        this.getLog().info((CharSequence)("file://" + htmlFile.getPath()));
    }

    private void printExecutionResults(Set<String> allFailures, CleanSurefireExecution exec) {
        this.getLog().info((CharSequence)"*********");
        this.getLog().info((CharSequence)("mvn nondex:nondex " + exec.getConfiguration().toArgLine()));
        Collection failedTests = exec.getConfiguration().getFailedTests();
        if (failedTests.isEmpty()) {
            this.getLog().info((CharSequence)"No Test Failed with this configuration.");
        }
        for (String test : failedTests) {
            allFailures.add(test);
            this.getLog().warn((CharSequence)test);
        }
        this.getLog().info((CharSequence)"*********");
    }

    private void writeCurrentRunInfo(CleanSurefireExecution execution) {
        try {
            Files.write(this.executions.get(0).getConfiguration().getRunFilePath(), (execution.getConfiguration().executionId + String.format("%n", new Object[0])).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            Logger.getGlobal().log(Level.SEVERE, "Cannot write execution id to current run file", (Throwable)ex);
        }
    }
}

