/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Level;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Mode;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.instr.Instrumenter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Execute(phase=LifecyclePhase.TEST_COMPILE)
public abstract class AbstractNonDexMojo
extends AbstractMojo {
    @Parameter(property="nondexSeed", defaultValue="933178")
    protected int seed;
    @Parameter(property="nondexMode", defaultValue="FULL")
    protected Mode mode;
    @Parameter(property="nondexFilter", defaultValue=".*")
    protected String filter;
    @Parameter(property="nondexStart", defaultValue="0")
    protected long start;
    @Parameter(property="nondexEnd", defaultValue="9223372036854775807")
    protected long end;
    @Parameter(property="nondexRunsWithoutShuffling", defaultValue="1")
    protected int numRunsWithoutShuffling;
    @Parameter(property="nondexRuns", defaultValue="3")
    protected int numRuns;
    @Parameter(property="nondexRerun", defaultValue="false")
    protected boolean rerun;
    @Parameter(property="nondexExecid", defaultValue="NoId")
    protected String executionId;
    @Parameter(property="nondexRunId", defaultValue="LATEST")
    protected String runId;
    @Parameter(property="nondexLogging", defaultValue="CONFIG")
    protected String loggingLevel;
    @Parameter(property="project")
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${basedir}")
    protected File baseDir;
    @Parameter(property="goal", alias="mojo")
    protected String goal;
    @Component
    protected MavenSession mavenSession;
    @Component
    protected BuildPluginManager pluginManager;
    protected Plugin surefire;
    protected String originalArgLine;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Logger.getGlobal().setLoggingLevel(Level.parse((String)this.loggingLevel));
        String rtPathStr = "";
        if (Utils.checkJDK8()) {
            Path rtPath = Utils.getRtJarLocation();
            if (rtPath == null) {
                Logger.getGlobal().log(Level.SEVERE, "Cannot find the rt.jar!");
                throw new MojoExecutionException("Cannot find the rt.jar!");
            }
            rtPathStr = rtPath.toString();
        }
        try {
            File fileForJar = Paths.get(this.baseDir.getAbsolutePath(), ".nondex").toFile();
            fileForJar.mkdirs();
            Instrumenter.instrument((String)rtPathStr, (String)Paths.get(fileForJar.getAbsolutePath(), "nondex-instr.jar").toString());
        }
        catch (IOException | NoSuchAlgorithmException exc) {
            exc.printStackTrace();
        }
        this.surefire = this.lookupPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        if (this.surefire == null) {
            Logger.getGlobal().log(Level.SEVERE, "Surefire is not explicitly declared in your pom.xml; we will use version 2.20, but you may want to change that.");
            this.surefire = this.getSureFirePlugin();
        }
        Properties localProperties = this.mavenProject.getProperties();
        this.originalArgLine = localProperties.getProperty("argLine", "");
    }

    private Plugin lookupPlugin(String paramString) {
        List localList = this.mavenProject.getBuildPlugins();
        for (Plugin localPlugin : localList) {
            if (!paramString.equalsIgnoreCase(localPlugin.getKey())) continue;
            return localPlugin;
        }
        return null;
    }

    private Plugin getSureFirePlugin() {
        Plugin surefire = new Plugin();
        surefire.setGroupId("org.apache.maven.plugins");
        surefire.setArtifactId("maven-surefire-plugin");
        surefire.setVersion("2.20");
        return surefire;
    }
}

