/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.ConfigurationDefaults;
import edu.illinois.nondex.common.Level;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Mode;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.plugin.CleanSurefireExecution;
import java.io.File;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class NonDexSurefireExecution
extends CleanSurefireExecution {
    private NonDexSurefireExecution(Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, String nondexDir) {
        super(surefire, originalArgLine, Utils.getFreshExecutionId(), mavenProject, mavenSession, pluginManager, nondexDir);
    }

    public NonDexSurefireExecution(Mode mode, int seed, Pattern filter, long start, long end, String nondexDir, String nondexJarDir, Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        this(surefire, originalArgLine, mavenProject, mavenSession, pluginManager, nondexDir);
        this.configuration = new Configuration(mode, seed, filter, start, end, nondexDir, nondexJarDir, null, this.executionId, Logger.getGlobal().getLoggingLevel());
    }

    public NonDexSurefireExecution(Configuration config, long start, long end, boolean print, String test, Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        this(surefire, originalArgLine, mavenProject, mavenSession, pluginManager, config.nondexDir);
        this.configuration = new Configuration(config.mode, config.seed, config.filter, start, end, config.nondexDir, config.nondexJarDir, test, this.executionId, Logger.getGlobal().getLoggingLevel(), print);
    }

    @Override
    protected void setupArgline(Xpp3Dom configNode) {
        String localRepo = this.mavenSession.getSettings().getLocalRepository();
        String pathToNondex = this.getPathToNondexJar(localRepo);
        String annotationsModuleName = "nondex-annotations";
        Xpp3Dom configElement = (Xpp3Dom)this.surefire.getConfiguration();
        if (configElement != null) {
            if (configElement.getChild("test") == null) {
                configElement.addChild(new Xpp3Dom("test"));
            }
            configElement.getChild("test").setValue(this.configuration.testName);
        }
        String argLineToSetPrefix = "-Xbootclasspath/p:";
        if (!Utils.checkJDKBefore8()) {
            argLineToSetPrefix = "--add-exports java.base/edu.illinois.nondex.common=ALL-UNNAMED --add-exports java.base/edu.illinois.nondex.shuffling=ALL-UNNAMED  --patch-module java.base=";
        }
        String argLineToSet = argLineToSetPrefix + pathToNondex + File.pathSeparator + Paths.get(this.mavenSession.getLocalRepository().getBasedir(), "edu", "illinois", annotationsModuleName, ConfigurationDefaults.VERSION, annotationsModuleName + "-" + ConfigurationDefaults.VERSION + ".jar") + " " + this.originalArgLine + " " + this.configuration.toArgLine();
        Logger.getGlobal().log(Level.FINE, "Running surefire with: " + this.configuration.toArgLine());
        this.mavenProject.getProperties().setProperty("argLine", this.originalArgLine + " " + argLineToSet);
        Logger.getGlobal().log(Level.FINE, "ArgLine being set to: " + argLineToSet);
        boolean added = false;
        for (Xpp3Dom config : configNode.getChildren()) {
            if (!"argLine".equals(config.getName())) continue;
            Logger.getGlobal().log(Level.INFO, "Adding NonDex argLine to existing argLine specified by the project");
            String current = NonDexSurefireExecution.sanitizeAndRemoveEnvironmentVars(config.getValue());
            config.setValue(argLineToSet + " " + current);
            Logger.getGlobal().log(Level.FINE, "Set argline to: " + argLineToSet + " " + current);
            added = true;
            break;
        }
        if (!added) {
            Logger.getGlobal().log(Level.INFO, "Creating new argline for Surefire");
            configNode.addChild(this.makeNode("argLine", argLineToSet));
        }
    }

    @Override
    protected Xpp3Dom applyNonDexConfig(Xpp3Dom configuration) {
        return this.addExcludedGroups(super.applyNonDexConfig(configuration));
    }

    private Xpp3Dom addExcludedGroups(Xpp3Dom configNode) {
        for (Xpp3Dom config : configNode.getChildren()) {
            if (!"excludedGroups".equals(config.getName())) continue;
            Logger.getGlobal().log(Level.INFO, "Adding excluded groups to existing ones");
            Object current = config.getValue();
            if (((String)current).contains("edu.illinois.NonDexIgnore")) {
                return configNode;
            }
            current = "," + (String)current;
            current = ((String)current).replace(",${excludedGroups}", "");
            config.setValue("edu.illinois.NonDexIgnore" + (String)current);
            return configNode;
        }
        Logger.getGlobal().log(Level.INFO, "Adding excluded groups to newly created one");
        configNode.addChild(this.makeNode("excludedGroups", "edu.illinois.NonDexIgnore"));
        return configNode;
    }

    private String getPathToNondexJar(String localRepo) {
        String result = Paths.get(this.configuration.nondexJarDir, "nondex-instr.jar") + File.pathSeparator + Paths.get(localRepo, "edu", "illinois", "nondex-common", ConfigurationDefaults.VERSION, "nondex-common-" + ConfigurationDefaults.VERSION + ".jar");
        Logger.getGlobal().log(Level.FINE, "The nondex path is: " + result);
        return "\"" + result + "\"";
    }
}

