/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.plugin;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Level;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Utils;
import edu.illinois.nondex.plugin.NonDexSurefireExecution;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class DebugTask {
    private String test;
    private Plugin surefire;
    private String originalArgLine;
    private MavenProject mavenProject;
    private MavenSession mavenSession;
    private BuildPluginManager pluginManager;
    private List<Configuration> failingConfigurations;

    public DebugTask(String test, Plugin surefire, String originalArgLine, MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, List<Configuration> failingConfigurations) {
        this.test = test;
        this.surefire = surefire;
        this.originalArgLine = originalArgLine;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
        this.failingConfigurations = failingConfigurations;
    }

    public String debug() throws MojoExecutionException {
        assert (!this.failingConfigurations.isEmpty());
        String defaultTest = this.test;
        String testClass = this.test.substring(0, this.test.indexOf(35));
        for (String test : new String[]{defaultTest, testClass, ""}) {
            this.test = test.contains("[") ? test.substring(0, test.indexOf(91)) : test;
            String result = this.tryDebugSeeds();
            if (result == null) continue;
            return result;
        }
        return "cannot reproduce. may be flaky due to other causes";
    }

    private String tryDebugSeeds() {
        List<Configuration> debuggedOnes = this.debugWithConfigurations(this.failingConfigurations);
        if (debuggedOnes.size() > 0) {
            return this.makeResultString(debuggedOnes);
        }
        Logger.getGlobal().log(Level.FINE, "TRYING NEW SEEDS");
        List<Configuration> retryWOtherSeeds = this.createNewSeedsToRetry();
        debuggedOnes = this.debugWithConfigurations(retryWOtherSeeds);
        if (debuggedOnes.size() > 0) {
            return this.makeResultString(debuggedOnes);
        }
        return null;
    }

    private String makeResultString(List<Configuration> debuggedOnes) {
        StringBuilder sb = new StringBuilder();
        for (Configuration config : debuggedOnes) {
            if (config == null) continue;
            sb.append(config.toArgLine());
            sb.append("\nDEBUG RESULTS FOR ");
            sb.append(config.testName);
            sb.append(" AND SEED: ");
            sb.append(config.seed);
            sb.append(" AT: ");
            sb.append(config.getDebugPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    private List<Configuration> createNewSeedsToRetry() {
        Configuration someFailingConfig = this.failingConfigurations.iterator().next();
        int newSeed = someFailingConfig.seed * 41444;
        LinkedList<Configuration> retryWOtherSeeds = new LinkedList<Configuration>();
        for (int i = 0; i < 10; ++i) {
            Configuration newConfig = new Configuration(someFailingConfig.mode, Utils.computeIthSeed((int)i, (boolean)false, (int)newSeed), someFailingConfig.filter, someFailingConfig.start, someFailingConfig.end, someFailingConfig.nondexDir, someFailingConfig.nondexJarDir, someFailingConfig.testName, someFailingConfig.executionId, someFailingConfig.loggingLevel);
            retryWOtherSeeds.add(newConfig);
        }
        return retryWOtherSeeds;
    }

    private List<Configuration> debugWithConfigurations(List<Configuration> failingConfigurations) {
        LinkedList<Configuration> allDebuggedConfigs = new LinkedList<Configuration>();
        for (Configuration config : failingConfigurations) {
            Configuration dryConfig = this.failsOnDry(config);
            if (dryConfig == null) continue;
            List<Configuration> debuggedConfigs = this.startDebugBinary(dryConfig);
            allDebuggedConfigs.addAll(debuggedConfigs);
        }
        return allDebuggedConfigs;
    }

    private Configuration failsOnDry(Configuration config) {
        return this.failsWithConfig(config, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public List<Configuration> startDebugBinary(Configuration config) {
        LinkedList<Configuration> allFailingConfigurations = new LinkedList<Configuration>();
        LinkedList<Pair> pairs = new LinkedList<Pair>();
        pairs.add(Pair.of((Object)Pair.of((Object)0L, (Object)config.getInvocationCount()), (Object)config));
        Configuration failingConfiguration = null;
        while (pairs.size() > 0) {
            long end;
            Pair pair = (Pair)pairs.remove(0);
            Pair range = (Pair)pair.getLeft();
            failingConfiguration = (Configuration)pair.getRight();
            long start = (Long)range.getLeft();
            if (start < (end = ((Long)range.getRight()).longValue())) {
                Logger.getGlobal().log(Level.INFO, "Debugging binary for " + this.test + " " + start + " : " + end);
                boolean binarySuccess = false;
                long midPoint = (start + end) / 2L;
                failingConfiguration = this.failsWithConfig(config, start, midPoint);
                if (failingConfiguration != null) {
                    pairs.add(Pair.of((Object)Pair.of((Object)start, (Object)midPoint), (Object)failingConfiguration));
                    binarySuccess = true;
                }
                if ((failingConfiguration = this.failsWithConfig(config, midPoint + 1L, end)) != null) {
                    pairs.add(Pair.of((Object)Pair.of((Object)(midPoint + 1L), (Object)end), (Object)failingConfiguration));
                    binarySuccess = true;
                }
                if (binarySuccess) continue;
                Logger.getGlobal().log(Level.SEVERE, "Binary splitting did not work. Going to linear");
                allFailingConfigurations.addAll(this.startDebugLinear(config, start, end));
                continue;
            }
            if (failingConfiguration == null) continue;
            allFailingConfigurations.add(this.reportDebugInfo(failingConfiguration));
        }
        return allFailingConfigurations;
    }

    private Configuration reportDebugInfo(Configuration failingConfiguration) {
        return this.failsWithConfig(failingConfiguration, failingConfiguration.start, failingConfiguration.end, true);
    }

    public List<Configuration> startDebugLinear(Configuration config, long start, long end) {
        LinkedList<Configuration> allFailingConfigurations = new LinkedList<Configuration>();
        LinkedList<Pair> pairs = new LinkedList<Pair>();
        pairs.add(Pair.of((Object)Pair.of((Object)start, (Object)end), (Object)config));
        Configuration failingConfiguration = null;
        while (pairs.size() > 0) {
            long localEnd;
            Pair pair = (Pair)pairs.remove(0);
            Pair range = (Pair)pair.getLeft();
            failingConfiguration = (Configuration)pair.getRight();
            long localStart = (Long)range.getLeft();
            if (localStart < (localEnd = ((Long)range.getRight()).longValue())) {
                Logger.getGlobal().log(Level.INFO, "Debugging linear for " + this.test + " " + localStart + " : " + localEnd);
                boolean found = false;
                failingConfiguration = this.failsWithConfig(config, localStart, localEnd - 1L);
                if (failingConfiguration != null) {
                    pairs.add(Pair.of((Object)Pair.of((Object)localStart, (Object)(localEnd - 1L)), (Object)failingConfiguration));
                    found = true;
                }
                if ((failingConfiguration = this.failsWithConfig(config, localStart + 1L, localEnd)) != null) {
                    pairs.add(Pair.of((Object)Pair.of((Object)(localStart + 1L), (Object)localEnd), (Object)failingConfiguration));
                    found = true;
                }
                if (found) continue;
                Logger.getGlobal().log(Level.FINE, "Refining did not work. Does not fail with linear on range " + localStart + " : " + localEnd + ".");
                continue;
            }
            if (failingConfiguration == null) continue;
            allFailingConfigurations.add(this.reportDebugInfo(failingConfiguration));
        }
        return allFailingConfigurations;
    }

    private Configuration failsWithConfig(Configuration config, long start, long end) {
        return this.failsWithConfig(config, start, end, false);
    }

    private Configuration failsWithConfig(Configuration config, long start, long end, boolean print) {
        NonDexSurefireExecution execution = new NonDexSurefireExecution(config, start, end, print, this.test, this.surefire, this.originalArgLine, this.mavenProject, this.mavenSession, this.pluginManager);
        try {
            execution.run();
        }
        catch (Throwable thr) {
            return execution.getConfiguration();
        }
        return null;
    }
}

