/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.starts.jdeps;

import edu.illinois.starts.constants.StartsConstants;
import edu.illinois.starts.enums.DependencyFormat;
import edu.illinois.starts.helpers.Cache;
import edu.illinois.starts.helpers.Loadables;
import edu.illinois.starts.helpers.PomUtil;
import edu.illinois.starts.helpers.RTSUtil;
import edu.illinois.starts.helpers.Writer;
import edu.illinois.starts.util.Logger;
import edu.illinois.yasgl.DirectedGraph;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefirePlugin;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.util.DefaultScanResult;

abstract class BaseMojo
extends SurefirePlugin
implements StartsConstants {
    static final String STAR = "*";
    @Parameter(property="filterLib", defaultValue="true")
    protected boolean filterLib;
    @Parameter(property="useThirdParty", defaultValue="false")
    protected boolean useThirdParty;
    protected String artifactsDir;
    @Parameter(property="depFormat", defaultValue="ZLC")
    protected DependencyFormat depFormat;
    @Parameter(property="gCache", defaultValue="${basedir}${file.separator}jdeps-cache")
    protected String graphCache;
    @Parameter(property="printGraph", defaultValue="true")
    protected boolean printGraph;
    @Parameter(defaultValue="graph", readonly=true, required=true)
    protected String graphFile;
    @Parameter(property="startsLogging", defaultValue="CONFIG")
    protected String loggingLevel;
    private Classpath sureFireClassPath;

    BaseMojo() {
    }

    protected void printResult(Set<String> set, String title) {
        Writer.writeToLog(set, (String)title, (Logger)Logger.getGlobal());
    }

    public String getArtifactsDir() throws MojoExecutionException {
        if (this.artifactsDir == null) {
            this.artifactsDir = this.basedir.getAbsolutePath() + File.separator + STARTS_DIRECTORY_PATH;
            File file = new File(this.artifactsDir);
            if (!file.mkdirs() && !file.exists()) {
                throw new MojoExecutionException("I could not create artifacts dir: " + this.artifactsDir);
            }
        }
        return this.artifactsDir;
    }

    public void setIncludesExcludes() throws MojoExecutionException {
        long start = System.currentTimeMillis();
        try {
            Field projectField = AbstractSurefireMojo.class.getDeclaredField("project");
            projectField.setAccessible(true);
            MavenProject accessedProject = (MavenProject)projectField.get((Object)this);
            List includes = PomUtil.getFromPom((String)"include", (MavenProject)accessedProject);
            List excludes = PomUtil.getFromPom((String)"exclude", (MavenProject)accessedProject);
            Logger.getGlobal().log(Level.FINEST, "@@Excludes: " + excludes);
            Logger.getGlobal().log(Level.FINEST, "@@Includes: " + includes);
            this.setIncludes(includes);
            this.setExcludes(excludes);
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] updateForNextRun(setIncludesExcludes): " + Writer.millsToSeconds((long)(end - start)));
    }

    public List getTestClasses(String methodName) {
        long start = System.currentTimeMillis();
        DefaultScanResult defaultScanResult = null;
        try {
            Method scanMethod = AbstractSurefireMojo.class.getDeclaredMethod("scanForTestClasses", null);
            scanMethod.setAccessible(true);
            defaultScanResult = (DefaultScanResult)scanMethod.invoke((Object)this, null);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] " + methodName + "(getTestClasses): " + Writer.millsToSeconds((long)(end - start)));
        return defaultScanResult.getFiles();
    }

    public ClassLoader createClassLoader(Classpath sfClassPath) {
        long start = System.currentTimeMillis();
        ClassLoader loader = null;
        try {
            loader = sfClassPath.createClassLoader(false, false, "MyRole");
        }
        catch (SurefireExecutionException see) {
            see.printStackTrace();
        }
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] updateForNextRun(createClassLoader): " + Writer.millsToSeconds((long)(end - start)));
        return loader;
    }

    public Classpath getSureFireClassPath() throws MojoExecutionException {
        long start = System.currentTimeMillis();
        if (this.sureFireClassPath == null) {
            try {
                this.sureFireClassPath = new Classpath((Collection)this.getProject().getTestClasspathElements());
            }
            catch (DependencyResolutionRequiredException drre) {
                drre.printStackTrace();
            }
        }
        Logger.getGlobal().log(Level.FINEST, "SF-CLASSPATH: " + this.sureFireClassPath.getClassPath());
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] updateForNextRun(getSureFireClassPath): " + Writer.millsToSeconds((long)(end - start)));
        return this.sureFireClassPath;
    }

    public Result prepareForNextRun(String sfPathString, Classpath sfClassPath, List<String> classesToAnalyze, Set<String> nonAffected, boolean computeUnreached) throws MojoExecutionException {
        long start = System.currentTimeMillis();
        String m2Repo = this.getLocalRepository().getBasedir();
        File jdepsCache = new File(this.graphCache);
        File libraryFile = new File(jdepsCache, "jdk.graph");
        Loadables loadables = new Loadables(classesToAnalyze, this.artifactsDir, sfPathString, this.useThirdParty, this.filterLib, jdepsCache);
        loadables.setSurefireClasspath(sfClassPath);
        long loadMoreEdges = System.currentTimeMillis();
        Cache cache = new Cache(jdepsCache, m2Repo);
        List moreEdges = new ArrayList();
        if (this.useThirdParty) {
            moreEdges = cache.loadM2EdgesFromCache(sfPathString);
        }
        long loadM2EdgesFromCache = System.currentTimeMillis();
        loadables.create(new ArrayList(moreEdges), sfClassPath, computeUnreached);
        Map transitiveClosure = loadables.getTransitiveClosure();
        long createLoadables = System.currentTimeMillis();
        Set affected = this.depFormat == DependencyFormat.ZLC ? null : RTSUtil.computeAffectedTests(new HashSet<String>(classesToAnalyze), nonAffected, (Map)transitiveClosure);
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] prepareForNextRun(loadMoreEdges): " + Writer.millsToSeconds((long)(loadMoreEdges - start)));
        Logger.getGlobal().log(Level.FINE, "[PROFILE] prepareForNextRun(loadM2EdgesFromCache): " + Writer.millsToSeconds((long)(loadM2EdgesFromCache - loadMoreEdges)));
        Logger.getGlobal().log(Level.FINE, "[PROFILE] prepareForNextRun(createLoadable): " + Writer.millsToSeconds((long)(createLoadables - loadM2EdgesFromCache)));
        Logger.getGlobal().log(Level.FINE, "[PROFILE] prepareForNextRun(computeAffectedTests): " + Writer.millsToSeconds((long)(end - createLoadables)));
        Logger.getGlobal().log(Level.FINE, "[PROFILE] updateForNextRun(prepareForNextRun(TOTAL)): " + Writer.millsToSeconds((long)(end - start)));
        return new Result(transitiveClosure, (DirectedGraph<String>)loadables.getGraph(), affected, loadables.getUnreached());
    }

    protected List<String> getAllClasses() {
        DirectoryScanner testScanner = new DirectoryScanner(this.getTestClassesDirectory(), new TestListResolver(STAR));
        DirectoryScanner classScanner = new DirectoryScanner(this.getClassesDirectory(), new TestListResolver(STAR));
        DefaultScanResult scanResult = classScanner.scan().append(testScanner.scan());
        return scanResult.getFiles();
    }

    protected class Result {
        private Map<String, Set<String>> testDeps;
        private DirectedGraph<String> graph;
        private Set<String> affectedTests;
        private Set<String> unreachedDeps;

        public Result(Map<String, Set<String>> testDeps, DirectedGraph<String> graph, Set<String> affectedTests, Set<String> unreached) {
            this.testDeps = testDeps;
            this.graph = graph;
            this.affectedTests = affectedTests;
            this.unreachedDeps = unreached;
        }

        public Map<String, Set<String>> getTestDeps() {
            return this.testDeps;
        }

        public DirectedGraph<String> getGraph() {
            return this.graph;
        }

        public Set<String> getAffectedTests() {
            return this.affectedTests;
        }

        public Set<String> getUnreachedDeps() {
            return this.unreachedDeps;
        }
    }
}

