/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.starts.jdeps;

import edu.illinois.starts.constants.StartsConstants;
import edu.illinois.starts.data.ZLCFormat;
import edu.illinois.starts.enums.DependencyFormat;
import edu.illinois.starts.helpers.EkstaziHelper;
import edu.illinois.starts.helpers.RTSUtil;
import edu.illinois.starts.helpers.Writer;
import edu.illinois.starts.helpers.ZLCHelper;
import edu.illinois.starts.jdeps.BaseMojo;
import edu.illinois.starts.util.Logger;
import edu.illinois.starts.util.Pair;
import edu.illinois.yasgl.DirectedGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.booter.Classpath;

@Mojo(name="diff", requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class DiffMojo
extends BaseMojo
implements StartsConstants {
    @Parameter(property="cleanBytes", defaultValue="true")
    protected boolean cleanBytes;
    @Parameter(property="zlcFormat", defaultValue="PLAIN_TEXT")
    protected ZLCFormat zlcFormat;
    @Parameter(property="updateDiffChecksums", defaultValue="false")
    private boolean updateDiffChecksums;

    public void execute() throws MojoExecutionException {
        Logger.getGlobal().setLoggingLevel(Level.parse(this.loggingLevel));
        Set<String> changed = new HashSet<String>();
        HashSet<String> nonAffected = new HashSet();
        Pair<Set<String>, Set<String>> data = this.computeChangeData(false);
        String extraText = "";
        if (data != null) {
            nonAffected = (Set)data.getKey();
            changed = (Set)data.getValue();
        } else {
            extraText = " (no RTS artifacts; likely the first run)";
        }
        this.printResult(changed, "ChangedClasses" + extraText);
        if (this.updateDiffChecksums) {
            this.updateForNextRun(nonAffected);
        }
    }

    protected Pair<Set<String>, Set<String>> computeChangeData(boolean writeChanged) throws MojoExecutionException {
        Set changed;
        long start = System.currentTimeMillis();
        Pair data = null;
        if (this.depFormat == DependencyFormat.ZLC) {
            ZLCHelper zlcHelper = new ZLCHelper();
            data = ZLCHelper.getChangedData((String)this.getArtifactsDir(), (boolean)this.cleanBytes);
        } else if (this.depFormat == DependencyFormat.CLZ) {
            data = EkstaziHelper.getNonAffectedTests((String)this.getArtifactsDir());
        }
        Set set = changed = data == null ? new HashSet() : (Set)data.getValue();
        if (writeChanged || Logger.getGlobal().getLoggingLevel().intValue() <= Level.FINEST.intValue()) {
            Writer.writeToFile(changed, (String)"changed-classes", (String)this.getArtifactsDir());
        }
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] COMPUTING CHANGES: " + Writer.millsToSeconds((long)(end - start)));
        return data;
    }

    protected void updateForNextRun(Set<String> nonAffected) throws MojoExecutionException {
        long start = System.currentTimeMillis();
        Classpath sfClassPath = this.getSureFireClassPath();
        String sfPathString = Writer.pathToString((List)sfClassPath.getClassPath());
        this.setIncludesExcludes();
        List allTests = this.getTestClasses("updateForNextRun");
        Set<String> affectedTests = new HashSet<String>(allTests);
        affectedTests.removeAll(nonAffected);
        DirectedGraph<String> graph = null;
        if (!affectedTests.isEmpty()) {
            HashSet unreached;
            ClassLoader loader = this.createClassLoader(sfClassPath);
            boolean computeUnreached = true;
            BaseMojo.Result result = this.prepareForNextRun(sfPathString, sfClassPath, allTests, (Set)nonAffected, computeUnreached);
            Map<String, Set<String>> testDeps = result.getTestDeps();
            graph = result.getGraph();
            HashSet hashSet = unreached = computeUnreached ? result.getUnreachedDeps() : new HashSet();
            if (this.depFormat == DependencyFormat.ZLC) {
                ZLCHelper zlcHelper = new ZLCHelper();
                ZLCHelper.updateZLCFile(testDeps, (ClassLoader)loader, (String)this.getArtifactsDir(), unreached, (boolean)this.useThirdParty, (ZLCFormat)this.zlcFormat);
            } else if (this.depFormat == DependencyFormat.CLZ) {
                affectedTests = result.getAffectedTests();
                if (affectedTests == null) {
                    throw new MojoExecutionException("Affected tests should not be null with CLZ format!");
                }
                RTSUtil.computeAndSaveNewCheckSums((String)this.getArtifactsDir(), affectedTests, testDeps, (ClassLoader)loader);
            }
        }
        this.save(this.getArtifactsDir(), affectedTests, allTests, sfPathString, graph);
        this.printToTerminal(allTests, affectedTests);
        long end = System.currentTimeMillis();
        Logger.getGlobal().log(Level.FINE, "[PROFILE] updateForNextRun(total): " + Writer.millsToSeconds((long)(end - start)));
    }

    public void printToTerminal(List<String> testClasses, Set<String> affectedTests) {
        Logger.getGlobal().log(Level.INFO, "STARTS:AffectedTests: " + affectedTests.size());
        Logger.getGlobal().log(Level.INFO, "STARTS:TotalTests: " + testClasses.size());
    }

    public void save(String artifactsDir, Set<String> affectedTests, List<String> testClasses, String sfPathString, DirectedGraph<String> graph) {
        int globalLogLevel = Logger.getGlobal().getLoggingLevel().intValue();
        if (globalLogLevel <= Level.FINER.intValue()) {
            Writer.writeToFile(testClasses, (String)"all-tests", (String)artifactsDir);
            Writer.writeToFile(affectedTests, (String)"selected-tests", (String)artifactsDir);
        }
        if (globalLogLevel <= Level.FINEST.intValue()) {
            RTSUtil.saveForNextRun((String)artifactsDir, graph, (boolean)this.printGraph, (String)this.graphFile);
            Writer.writeClassPath((String)sfPathString, (String)artifactsDir);
        }
    }
}

