/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.starts.jdeps;

import edu.illinois.starts.constants.StartsConstants;
import edu.illinois.starts.data.ZLCFormat;
import edu.illinois.starts.helpers.RTSUtil;
import edu.illinois.starts.helpers.Writer;
import edu.illinois.starts.helpers.ZLCHelper;
import edu.illinois.starts.jdeps.BaseMojo;
import edu.illinois.starts.jdeps.DiffMojo;
import edu.illinois.starts.util.Logger;
import edu.illinois.starts.util.Pair;
import edu.illinois.yasgl.DirectedGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.booter.Classpath;

@Mojo(name="impacted", requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class ImpactedMojo
extends DiffMojo
implements StartsConstants {
    @Parameter(property="updateImpactedChecksums", defaultValue="false")
    private boolean updateImpactedChecksums;
    @Parameter(property="writePath", defaultValue="false")
    private boolean writePath;
    @Parameter(property="trackNewClasses", defaultValue="false")
    private boolean trackNewClasses;
    @Parameter(property="trackNonImpacted", defaultValue="false")
    private boolean trackNonImpacted;
    private Logger logger;

    @Override
    public void execute() throws MojoExecutionException {
        Logger.getGlobal().setLoggingLevel(Level.parse(this.loggingLevel));
        this.logger = Logger.getGlobal();
        Pair<Set<String>, Set<String>> data = this.computeChangeData(false);
        List<String> allClasses = this.getAllClasses();
        if (allClasses.isEmpty()) {
            this.logger.log(Level.INFO, "There are no .class files in this module.");
            return;
        }
        HashSet<String> impacted = new HashSet<String>(allClasses);
        Set nonAffected = data == null ? new HashSet() : (Set)data.getKey();
        Set changed = data == null ? new HashSet() : (Set)data.getValue();
        impacted.removeAll(nonAffected);
        this.logger.log(Level.FINEST, "CHANGED: " + changed.toString());
        this.logger.log(Level.FINEST, "IMPACTED: " + ((Object)impacted).toString());
        if (this.trackNewClasses) {
            HashSet<String> newClasses = new HashSet<String>(allClasses);
            Set oldClasses = ZLCHelper.getExistingClasses((String)this.getArtifactsDir());
            newClasses.removeAll(oldClasses);
            this.logger.log(Level.FINEST, "NEWLY-ADDED: " + ((Object)newClasses).toString());
            Writer.writeToFile(newClasses, (String)"new-classes", (String)this.getArtifactsDir());
        }
        if (this.updateImpactedChecksums) {
            this.updateForNextRun(allClasses);
        }
        Writer.writeToFile(changed, (String)"changed-classes", (String)this.getArtifactsDir());
        Writer.writeToFile(impacted, (String)"impacted-classes", (String)this.getArtifactsDir());
        if (this.trackNonImpacted) {
            Writer.writeToFile(nonAffected, (String)"non-impacted-classes", (String)this.getArtifactsDir());
        }
    }

    private void updateForNextRun(List<String> allClasses) throws MojoExecutionException {
        long start = System.currentTimeMillis();
        Classpath sfClassPath = this.getSureFireClassPath();
        String sfPathString = Writer.pathToString((List)sfClassPath.getClassPath());
        ClassLoader loader = this.createClassLoader(sfClassPath);
        BaseMojo.Result result = this.prepareForNextRun(sfPathString, sfClassPath, (List)allClasses, (Set)new HashSet(), false);
        ZLCHelper zlcHelper = new ZLCHelper();
        ZLCHelper.updateZLCFile(result.getTestDeps(), (ClassLoader)loader, (String)this.getArtifactsDir(), new HashSet(), (boolean)this.useThirdParty, (ZLCFormat)this.zlcFormat);
        long end = System.currentTimeMillis();
        if (this.writePath || this.logger.getLoggingLevel().intValue() <= Level.FINER.intValue()) {
            Writer.writeClassPath((String)sfPathString, (String)this.getArtifactsDir());
        }
        if (this.logger.getLoggingLevel().intValue() <= Level.FINEST.intValue()) {
            this.save(this.getArtifactsDir(), result.getGraph());
        }
        Logger.getGlobal().log(Level.FINE, "[PROFILE] updateForNextRun(total): " + Writer.millsToSeconds((long)(end - start)));
    }

    private void save(String artifactsDir, DirectedGraph<String> graph) {
        RTSUtil.saveForNextRun((String)artifactsDir, graph, (boolean)this.printGraph, (String)this.graphFile);
    }
}

