/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.starts.jdeps;

import edu.illinois.starts.constants.StartsConstants;
import edu.illinois.starts.helpers.Writer;
import edu.illinois.starts.jdeps.DiffMojo;
import edu.illinois.starts.maven.AgentLoader;
import edu.illinois.starts.util.Logger;
import edu.illinois.starts.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
public class RunMojo
extends DiffMojo
implements StartsConstants {
    private static final String TARGET = "target";
    @Parameter(property="updateRunChecksums", defaultValue="true")
    protected boolean updateRunChecksums;
    @Parameter(property="retestAll", defaultValue="false")
    protected boolean retestAll;
    @Parameter(property="writeNonAffected", defaultValue="false")
    protected boolean writeNonAffected;
    @Parameter(property="writeChangedClasses", defaultValue="false")
    protected boolean writeChangedClasses;
    protected Set<String> nonAffectedTests;
    protected Set<String> changedClasses;
    protected List<Pair> jarCheckSums = null;
    private Logger logger;

    @Override
    public void execute() throws MojoExecutionException {
        Logger.getGlobal().setLoggingLevel(Level.parse(this.loggingLevel));
        this.logger = Logger.getGlobal();
        long start = System.currentTimeMillis();
        this.setIncludesExcludes();
        this.run();
        HashSet allTests = new HashSet(this.getTestClasses("checkIfAllAffected"));
        if (this.writeNonAffected || this.logger.getLoggingLevel().intValue() <= Level.FINEST.intValue()) {
            Writer.writeToFile(this.nonAffectedTests, (String)"non-affected-tests", (String)this.getArtifactsDir());
        }
        if (allTests.equals(this.nonAffectedTests)) {
            this.logger.log(Level.INFO, "********** Run **********");
            this.logger.log(Level.INFO, "No tests are selected to run.");
        }
        long end = System.currentTimeMillis();
        System.setProperty("[PROFILE] END-OF-RUN-MOJO: ", Long.toString(end));
        this.logger.log(Level.FINE, "[PROFILE] RUN-MOJO-TOTAL: " + Writer.millsToSeconds((long)(end - start)));
    }

    protected void run() throws MojoExecutionException {
        String cpString = Writer.pathToString((List)this.getSureFireClassPath().getClassPath());
        List<String> sfPathElements = this.getCleanClassPath(cpString);
        if (!this.isSameClassPath(sfPathElements) || !this.hasSameJarChecksum(sfPathElements)) {
            this.dynamicallyUpdateExcludes(new ArrayList<String>());
            this.nonAffectedTests = new HashSet<String>();
            Writer.writeClassPath((String)cpString, (String)this.artifactsDir);
            Writer.writeJarChecksums(sfPathElements, (String)this.artifactsDir, this.jarCheckSums);
        } else if (this.retestAll) {
            this.setChangedAndNonaffected();
            this.dynamicallyUpdateExcludes(new ArrayList<String>());
        } else {
            this.setChangedAndNonaffected();
            List excludePaths = Writer.fqnsToExcludePath(this.nonAffectedTests);
            this.dynamicallyUpdateExcludes(excludePaths);
        }
        long startUpdateTime = System.currentTimeMillis();
        if (this.updateRunChecksums) {
            this.updateForNextRun(this.nonAffectedTests);
        }
        long endUpdateTime = System.currentTimeMillis();
        this.logger.log(Level.FINE, "[PROFILE] STARTS-MOJO-UPDATE-TIME: " + Writer.millsToSeconds((long)(endUpdateTime - startUpdateTime)));
    }

    private void dynamicallyUpdateExcludes(List<String> excludePaths) throws MojoExecutionException {
        if (!AgentLoader.loadDynamicAgent()) {
            throw new MojoExecutionException("I COULD NOT ATTACH THE AGENT");
        }
        this.logger.log(Level.FINEST, "AGENT LOADED!!!");
        System.setProperty("STARTS_EXCLUDES", Arrays.toString(excludePaths.toArray(new String[0])));
    }

    protected void setChangedAndNonaffected() throws MojoExecutionException {
        this.nonAffectedTests = new HashSet<String>();
        this.changedClasses = new HashSet<String>();
        Pair<Set<String>, Set<String>> data = this.computeChangeData(this.writeChangedClasses);
        this.nonAffectedTests = data == null ? new HashSet() : (Set)data.getKey();
        this.changedClasses = data == null ? new HashSet() : (Set)data.getValue();
    }

    private boolean isSameClassPath(List<String> sfPathString) throws MojoExecutionException {
        if (sfPathString.isEmpty()) {
            return true;
        }
        String oldSfPathFileName = Paths.get(this.getArtifactsDir(), "sf-classpath").toString();
        if (!new File(oldSfPathFileName).exists()) {
            return false;
        }
        try {
            List<String> oldClassPathLines = Files.readAllLines(Paths.get(oldSfPathFileName, new String[0]));
            if (oldClassPathLines.size() != 1) {
                throw new MojoExecutionException("sf-classpath is corrupt! Expected only 1 line.");
            }
            List<String> oldClassPathelements = this.getCleanClassPath(oldClassPathLines.get(0));
            if (sfPathString.equals(oldClassPathelements)) {
                return true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    private boolean hasSameJarChecksum(List<String> cleanSfClassPath) throws MojoExecutionException {
        if (cleanSfClassPath.isEmpty()) {
            return true;
        }
        String oldChecksumPathFileName = Paths.get(this.getArtifactsDir(), "jar-checksums").toString();
        if (!new File(oldChecksumPathFileName).exists()) {
            return false;
        }
        boolean noException = true;
        try {
            List<String> lines = Files.readAllLines(Paths.get(oldChecksumPathFileName, new String[0]));
            HashMap<String, String> checksumMap = new HashMap<String, String>();
            for (String line : lines) {
                String[] elems = line.split(",");
                checksumMap.put(elems[0], elems[1]);
            }
            this.jarCheckSums = new ArrayList<Pair>();
            for (String path : cleanSfClassPath) {
                Pair pair = Writer.getJarToChecksumMapping((String)path);
                this.jarCheckSums.add(pair);
                String oldCS = (String)checksumMap.get(pair.getKey());
                noException &= ((String)pair.getValue()).equals(oldCS);
            }
        }
        catch (IOException ioe) {
            noException = false;
            this.jarCheckSums = null;
            ioe.printStackTrace();
        }
        return noException;
    }

    private List<String> getCleanClassPath(String cp) {
        ArrayList<String> cpPaths = new ArrayList<String>();
        String[] paths = cp.split(File.pathSeparator);
        String classes = File.separator + TARGET + File.separator + "classes";
        String testClasses = File.separator + TARGET + File.separator + "test-classes";
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].contains(classes) || paths[i].contains(testClasses)) continue;
            cpPaths.add(paths[i]);
        }
        return cpPaths;
    }
}

