/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.starts.jdeps;

import edu.illinois.starts.constants.StartsConstants;
import edu.illinois.starts.helpers.Writer;
import edu.illinois.starts.jdeps.DiffMojo;
import edu.illinois.starts.util.Logger;
import edu.illinois.starts.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="select", requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class SelectMojo
extends DiffMojo
implements StartsConstants {
    @Parameter(property="updateSelectChecksums", defaultValue="false")
    private boolean updateSelectChecksums;
    private Logger logger;

    @Override
    public void execute() throws MojoExecutionException {
        Logger.getGlobal().setLoggingLevel(Level.parse(this.loggingLevel));
        this.logger = Logger.getGlobal();
        long start = System.currentTimeMillis();
        Set<String> affectedTests = this.computeAffectedTests();
        this.printResult(affectedTests, "AffectedTests");
        long end = System.currentTimeMillis();
        this.logger.log(Level.FINE, "[PROFILE] RUN-MOJO-TOTAL: " + Writer.millsToSeconds((long)(end - start)));
        this.logger.log(Level.FINE, "[PROFILE] TEST-RUNNING-TIME: 0.0");
    }

    private Set<String> computeAffectedTests() throws MojoExecutionException {
        this.setIncludesExcludes();
        HashSet allTests = new HashSet(this.getTestClasses("checkIfAllAffected"));
        HashSet<String> affectedTests = new HashSet<String>(allTests);
        Pair<Set<String>, Set<String>> data = this.computeChangeData(false);
        HashSet<String> nonAffectedTests = data == null ? new HashSet() : (Set)data.getKey();
        affectedTests.removeAll(nonAffectedTests);
        if (allTests.equals(nonAffectedTests)) {
            this.logger.log(Level.INFO, "********** Run **********");
            this.logger.log(Level.INFO, "No tests are selected to run.");
        }
        long startUpdate = System.currentTimeMillis();
        if (this.updateSelectChecksums) {
            this.updateForNextRun(nonAffectedTests);
        }
        long endUpdate = System.currentTimeMillis();
        this.logger.log(Level.FINE, "[PROFILE] STARTS-MOJO-UPDATE-TIME: " + Writer.millsToSeconds((long)(endUpdate - startUpdate)));
        return affectedTests;
    }
}

