/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.yasgl;

import edu.illinois.yasgl.Graph;
import edu.illinois.yasgl.GraphVertexVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGraph<V>
implements Graph<V> {
    @Override
    public Set<V> acceptForward(V v, GraphVertexVisitor<V> visitor) {
        assert (this.getVertices().contains(v));
        return this.acceptForward(v, visitor, new HashSet());
    }

    @Override
    public Set<V> acceptForward(Collection<V> vs, GraphVertexVisitor<V> visitor) {
        HashSet visited = new HashSet();
        for (V v : vs) {
            assert (this.getVertices().contains(v));
            this.acceptForward(v, visitor, visited);
        }
        return visited;
    }

    private Set<V> acceptForward(V v, GraphVertexVisitor<V> visitor, Set<V> visited) {
        if (!visited.add(v)) {
            return visited;
        }
        visitor.visit(v);
        for (V vert : this.getSuccessors(v)) {
            this.acceptForward(vert, visitor, visited);
        }
        return visited;
    }

    @Override
    public Set<V> acceptBackward(V v, GraphVertexVisitor<V> visitor) {
        assert (this.getVertices().contains(v));
        return this.acceptBackward(v, visitor, new HashSet());
    }

    @Override
    public Set<V> acceptBackward(Collection<V> vs, GraphVertexVisitor<V> visitor) {
        HashSet visited = new HashSet();
        for (V v : vs) {
            assert (this.getVertices().contains(v));
            this.acceptBackward(v, visitor, visited);
        }
        return visited;
    }

    private Set<V> acceptBackward(V v, GraphVertexVisitor<V> visitor, Set<V> visited) {
        if (!visited.add(v)) {
            return visited;
        }
        visitor.visit(v);
        for (V vert : this.getPredecessors(v)) {
            this.acceptBackward(vert, visitor, visited);
        }
        return visited;
    }

    public void toGiraphString(Map<V, Long> outMap, Writer sb) throws IOException {
        Long l = outMap.values().stream().max(Comparator.naturalOrder()).orElse(0L);
        for (Object key : this.getVertices()) {
            if (!outMap.containsKey(key)) {
                Long l2 = l;
                Long l3 = l = Long.valueOf(l + 1L);
                outMap.put((Long)key, l2);
            }
            sb.write(outMap.get(key).toString());
            for (Object val : this.getSuccessors(key)) {
                if (!outMap.containsKey(val)) {
                    Long l4 = l;
                    Long l5 = l = Long.valueOf(l + 1L);
                    outMap.put((Long)val, l4);
                }
                sb.write("\t");
                sb.write(outMap.get(val).toString());
            }
            sb.write("\n");
        }
    }
}

