/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.yasgl;

import edu.illinois.yasgl.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DFSTask<V>
implements Runnable {
    private final Graph<V> graph;
    private Map<V, Set<V>> resultsMap;
    private final Collection<V> vertices;

    public DFSTask(Graph<V> graph, Map<V, Set<V>> results) {
        this(graph, results, graph.getVertices());
    }

    public DFSTask(Graph<V> graph, Map<V, Set<V>> results, Collection<V> startingPoints) {
        this.graph = graph;
        this.resultsMap = results;
        this.vertices = startingPoints;
    }

    @Override
    public void run() {
        LinkedList<Object> worklist = new LinkedList<Object>();
        worklist.addAll(this.graph.getVertices());
        this.vertices.stream().forEach(v -> this.resultsMap.put(v, Collections.newSetFromMap(new HashMap())));
        this.vertices.stream().forEach(v -> this.resultsMap.get(v).add(v));
        this.vertices.stream().forEach(v -> this.resultsMap.get(v).addAll(this.graph.getSuccessors(v)));
        this.resultsMap = Collections.unmodifiableMap(this.resultsMap);
        while (!worklist.isEmpty()) {
            Object current = worklist.remove();
            Set<V> currentTc = this.resultsMap.get(current);
            Set nexts = Collections.newSetFromMap(new HashMap());
            currentTc.stream().map(v -> this.resultsMap.get(v)).forEach(vs -> nexts.addAll(vs));
            if (!currentTc.addAll(nexts)) continue;
            worklist.add(current);
        }
    }
}

