/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.yasgl;

import com.google.common.collect.ImmutableMultimap;
import edu.illinois.yasgl.AbstractGraph;
import edu.illinois.yasgl.DirectedGraphBuilder;
import edu.illinois.yasgl.Edge;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class DirectedGraph<V>
extends AbstractGraph<V> {
    private static final long serialVersionUID = -3303603645240328439L;
    final ImmutableMultimap<V, V> forward;
    final ImmutableMultimap<V, V> backward;
    final Collection<V> vertices;

    protected DirectedGraph(ImmutableMultimap<V, V> forward, Collection<V> vertices) {
        this.forward = forward;
        this.backward = this.forward.inverse();
        this.vertices = vertices;
    }

    private DirectedGraph(ImmutableMultimap<V, V> forward, ImmutableMultimap<V, V> backward, Collection<V> vertices) {
        this.forward = forward;
        this.backward = backward;
        this.vertices = vertices;
    }

    @Override
    public DirectedGraph<V> inverse() {
        return new DirectedGraph<V>(this.backward, this.forward, this.vertices);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.forward.get(vertex);
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        return this.backward.get(vertex);
    }

    public Collection<V> vertexSet() {
        return Collections.unmodifiableCollection(this.vertices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (V v : this.vertices) {
            sb.append("<");
            sb.append(v);
            sb.append(" -> ");
            sb.append(this.forward.containsKey(v) ? this.forward.get(v) : "{}");
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices);
    }

    @Override
    public Collection<Edge<V>> getEdges() {
        return this.forward.entries().stream().map(e -> new Edge(e.getKey(), e.getValue())).collect(Collectors.toSet());
    }

    public static DirectedGraph<Long> fromGiraphString(String fileName) {
        DirectedGraphBuilder<Long> graphBuilder = new DirectedGraphBuilder<Long>();
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                long[] tokens = Arrays.stream(sCurrentLine.split("\\s+")).mapToLong(x -> Long.parseLong(x)).toArray();
                graphBuilder.addVertex(tokens[0]);
                for (int i = 1; i < tokens.length; ++i) {
                    graphBuilder.addEdge(tokens[0], tokens[i]);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return graphBuilder.build();
    }

    public static <T> DirectedGraph<T> fromGiraphString(String fileName, Map<Long, T> map) {
        DirectedGraphBuilder<T> graphBuilder = new DirectedGraphBuilder<T>();
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                long[] tokens = Arrays.stream(sCurrentLine.split("\\s+")).mapToLong(x -> Long.parseLong(x)).toArray();
                graphBuilder.addVertex(map.get(tokens[0]));
                for (int i = 1; i < tokens.length; ++i) {
                    graphBuilder.addEdge(map.get(tokens[0]), map.get(tokens[i]));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return graphBuilder.build();
    }
}

