/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.yasgl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import edu.illinois.yasgl.DirectedGraph;
import java.util.Collection;
import java.util.HashSet;

public class DirectedGraphBuilder<V> {
    private final ImmutableMultimap.Builder<V, V> forward = ImmutableSetMultimap.builder();
    private final Collection<V> vertices = new HashSet<V>();

    public DirectedGraphBuilder() {
    }

    public DirectedGraphBuilder(DirectedGraph<V> g) {
        this.vertices.addAll(g.vertices);
        for (Object pre : g.forward.keys()) {
            for (Object suc : g.forward.get(pre)) {
                this.addEdge(pre, suc);
            }
        }
    }

    public void addEdge(V vertex1, V vertex2) {
        this.addVertex(vertex1);
        this.addVertex(vertex2);
        this.forward.put(vertex1, vertex2);
    }

    public void addVertex(V vertex) {
        this.vertices.add(vertex);
    }

    public DirectedGraph<V> build() {
        ImmutableMultimap multi = this.forward.build();
        return new DirectedGraph(multi, ImmutableSet.copyOf(this.vertices));
    }
}

